<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0004"
	title    = "コード"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,CLM,CODE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
		select
		'1' as WRITABLE,A.CLM,B.NAME_JA,C.LNAME,C.SNAME,A.CODE,A.SEQNO,
		A.CODELVL,A.CODEGRP,A.CODE_PARAM,A.KBSAKU,A.COMMENTS,C.DESCRIPTION,A.SYSTEM_ID,
		A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ,C.LANG,'0' EXIST_GEA08,0 UNIQ_GEA08,A.CLM CLM_T
		from ( select Z.*, Z.CLM{@DBF.CON}'.'{@DBF.CON}Z.CODE CKEY from GEA04 Z
				where Z.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
				<og:where startKey="and">
					<og:and value = "Z.FGJ			=	'{@FGJ}'"			/>
					<og:and value = "UPPER(Z.CLM)	like UPPER('{@CLM}')"	/>
					<og:and value = "UPPER(Z.CODE)	like UPPER('{@CODE}')"	/>
					<og:and value = "Z.KBSAKU		=	'{@KBSAKU}'"		/>
					<og:and value = "Z.CODEGRP		like '{@CODEGRP}'"		/>
		<!--		<og:and value = "Z.RDC_CODE		=	'{@RDC_CODE}'"		/>		-->
		<!--		<og:and value = "Z.DYUPD &gt;	=	'{@DYUPDFROM}'"		/>		-->
		<!--		<og:and value = "Z.DYUPD &lt;	=	'{@DYUPDTO}99'"		/>		-->
		<!--		<og:and value = "Z.RELEASE_NOTES like '{@RELEASE_NOTES}'" />	-->
		<!--		<og:and value = "Z.USRUPD		=	'{@USRUPD}'"		/>		-->
					<og:and value = "Z.CDKH {@CDKH}"						/>
				</og:where>
		) A
		left outer join GEA03 B
			on A.SYSTEM_ID = B.SYSTEM_ID
			and A.CLM = B.CLM
			and B.FGJ = '1'
		left outer join GEA08 C
			on A.SYSTEM_ID = C.SYSTEM_ID
			and A.CKEY = C.CLM
			and C.FGJ = '1'
		<og:where startKey="and">
			<og:and value = "C.LANG	=	'{@LANG}'"	/>
		</og:where>
	<og:where>
		<og:and value = "B.NAME_JA	like '{@NAME_JA}'"	/>
		<og:and value = "C.LNAME	like '{@LNAME}'"	/>
		<og:and value = "C.SNAME	like '{@SNAME}'"	/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,C.LANG,A.SEQNO,A.SYSTEM_ID DESC,A.KBSAKU DESC,B.KBSAKU DESC,C.KBSAKU DESC" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,[SYSTEM_ID],[CLM],1" />
	<og:link column="LNAME" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,[SYSTEM_ID],[CLM],1" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" nullCheck="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="NAME_JA" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,CODE,NAME_JA,KBSAKU,RDC_CODE,CDKH,FGJ"  />
		<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
		<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"/>
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA04" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  action="COPY" noWritable="NAME_JA" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  action="COPY"    noWritable="NAME_JA" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,CODE,NAME_JA,KBSAKU,RDC_CODE,CDKH"  />
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
		{@USER.LASTSQL}
	</og:query>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,CODE,KBSAKU"
		diffKeys      = "SEQNO,CODELVL,CODEGRP,CODE_PARAM"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,EXIST_GEA08,UNIQ_GEA08,CLM_T"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
