/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * HMS レンデラーは、カラムのデータを時：分：秒に分けて表示する場合に
 * 使用するクラスです。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.group データ表示
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_HMS extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.6.5.0 (2013/06/07)" ;

	private static final CellRenderer dbCell = new Renderer_HMS() ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.1.2.1 (2003/04/10) synchronized を、削除します。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 * ここでは、null か ゼロ文字列の場合は、ゼロ文字列を返します。
	 * ６ケタ、１４ケタでないデータは、エラー表示を行います。
	 * ６ケタの場合は、HHMMSS として、HH:MM:SS を返します。
	 * １４ケタの場合は、yyyyMMddHHmmss として、そのうちの時分秒の HH:MM:SS のみ返します。
	 *
	 * @og.rev 5.5.7.2 (2012/10/09) 処理ロジックの見直し
	 * @og.rev 5.6.5.0 (2013/06/07) １４ケタも処理するように変更
	 *
	 * @param	value 入力値
	 *
	 * @return	データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		if( value == null || value.length() == 0 ) { return ""; }

		String rtn = value;

		if( rtn.length() == 6 ) {
			char[] ch1 = new char[8];
			ch1[0] = rtn.charAt(0);
			ch1[1] = rtn.charAt(1);
			ch1[2] = ':' ;
			ch1[3] = rtn.charAt(2);
			ch1[4] = rtn.charAt(3);
			ch1[5] = ':' ;
			ch1[6] = rtn.charAt(4);
			ch1[7] = rtn.charAt(5);

			rtn = new String( ch1 );
		}
		// 5.6.5.0 (2013/06/07) １４ケタも処理する
		else if( rtn.length() == 14 ) {
			char[] ch1 = new char[8];
			ch1[0] = rtn.charAt(8);
			ch1[1] = rtn.charAt(9);
			ch1[2] = ':' ;
			ch1[3] = rtn.charAt(10);
			ch1[4] = rtn.charAt(11);
			ch1[5] = ':' ;
			ch1[6] = rtn.charAt(12);
			ch1[7] = rtn.charAt(13);

			rtn = new String( ch1 );
		}
		else {
			rtn = "<span class=\"error\">" + value + "</span>";
		}
		return rtn;
	}
}
