/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

/**
 * プルダウンメニューやデータリストを作成する場合の共通インターフェースです。
 *
 * これは、BODY部の optionタグからの情報を、取得する為に、SelectTag と DatalistTag の
 * 共通インターフェースとして定義します。
 *
 * @og.rev 5.7.1.0 (2013/12/06) 新規追加
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface OptionAncestorIF  {

	/**
	 * メニュー項目の選択項目を追加します。
	 *
	 * select タグのBODY要素の OptionTag よりアクセスされます。
	 *
	 * @param	opt 	 オプションタグ文字列
	 */
	void addOption( final String opt ) ;

	/**
	 * 値を外部から取り出します。
	 *
	 * OptionTag で、value を取り出して、内部の値と同じ場合は、選択状態にします。
	 *
	 * @return	内部に設定された値
	 */
	String getValue();

	/**
	 * 複数選択可能時に全選択を設定するかどうかを返します。
	 *
	 * これは、上位入れ子のタグの OptionTag で、multipleAll を取り出して、
	 * true であれば、全選択に設定します。
	 *
	 * @return	全選択:true / 通常:false
	 */
	boolean isMultipleAll();

	/**
	 * パラメーター変換({&#064;XXXX}の置き換えをしない状態のパラメーターをセットします。
	 *
	 * @param   param パラメーター
	 */
	void setRawParam( final String param );
}
