<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2190"
	title	= "移行DB対応明細"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- FIRSTシートに表示する対象テーブル一覧の検索。後で、tableMerge する為、検索項目を合わせておきます。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request" tableId="FIRST">
		select 	T_TABLE_NAME , T_NAME_JA as T_TABLE_LBL , '' as T_SEQNO , '' as T_CLM , '' as T_NAME_JA
			  , '' as T_CLS_NAME , '' as T_USE_LENGTH , '' as T_DTYPE , '' as T_BIKO
			  , '' as T_SYSTEM_ID
			  , '' as T_CONST, NOJUN , '' as CONV_FUNC , BIKO
			  , F_TABLE_NAME , F_NAME_JA as F_TABLE_LBL , '' as F_SEQNO , '' as F_CLM , '' as F_NAME_JA
			  , '' as F_CLS_NAME , '' as F_USE_LENGTH , '' as F_DTYPE , '' as F_BIKO
			  , '' as FGJ , '' as UNIQ , CDIKOU , '{@LBL.GF2180}' as PAGEBREAK
		from GF84
	<og:where>
		<og:and value = "FGJ			in  ('0','1')"				/>
		<og:and value = "T_SYSTEM_ID	=    '{@T_SYSTEM_ID}'"		/>
	</og:where>
		order by T_SYSTEM_ID,NOJUN,T_TABLE_NAME
</og:query>

<!-- FIRSTシートを前に、通常の検索結果を後ろにマージします。-->
<og:tableMerge
	action			= "UNION_ALL"
	masterTableId	= "FIRST"
	masterScope		= "request"
	slaveScope		= "session"
/>

<!-- useSheetName="true" で、PAGEBREAK の値を、シート名に使用します。 -->
<og:report2
	fileURL			= "{@SYS.REAL_PATH}jsp/{@GUI.ADDRESS}"
	listId			= "DBDEF1"
	outFileURL		= "{@USER.ID}"
	outFilename		= "{@GUI.NAME}.xls"
	useSheetName	= "true"
	fgrun			= "E"
	debug			= "{@debug}"
/>

<og:forward page="{@SYS.JSP}/fileDownload" keys="file" vals="{@SYS.FILE_URL}{@USER.ID}/{@GUI.NAME}.xls" useRedirect="true" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
