<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	maxPostSize = "20000000"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1"
/>

<!-- ファイルアップロードで、アップロードされたファイルは、UPLOAD_FILES リクエスト変数にカンマ区切りで保存しています。 -->
<c:forTokens items = "${UPLOAD_FILES}" delims = "," var = "filename" >
	<og:file fileURL="{@USER.ID}" file1="tempUpload.xls" action="existsLength" >
		<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
		<og:text>fileURL="{@USER.ID}" file1="tempUpload.xls"</og:text>
	</og:file>

	<og:readTable
		command		= "NEW"
		readerClass = "Excel"
		useNumber   = "false"
		skipRowCount= "6"
		modifyType	= "A"
		fileURL		= "{@USER.ID}"
		filename	= "${filename}"
		encode		= "UnicodeLittle"
		adjustColumns	= "*"
		sheetNos    = "{@sheetNos}"
		sheetConstKeys	= "TABLE_NAME,NAME_JA"
		sheetConstAdrs	= "3-0,6-7"
		nullBreakClm	= "SEQNO"
		columns		= "SEQNO,CLM,CLS_NAME,USE_LENGTH,PHY_LENGTH,NOT_NULL,UK,CLM_NAME,TABLE_NAME,NAME_JA"
		maxRowCount	= "0"
		debug		= "{@debug}"
	/>

	<og:value command="SET" key="LENGTH_FUNC">
	case when [PHY_LENGTH] is null or [PHY_LENGTH] = 0 then [USE_LENGTH] else [USE_LENGTH] || ',' || [PHY_LENGTH] end
	</og:value>

	<og:value command="SET" key="NOT_NULL">
	case when [NOT_NULL] is null then null else 1 end
	</og:value>

	<!-- 登録処理をおこないます。 -->
	<!-- constObjKey="GF" で、DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD を自動セットします。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF80"
			omitNames	= "PHY_LENGTH"
			funcKeys	= "USE_LENGTH,NOT_NULL"
			funcVals	= "{@LENGTH_FUNC},{@NOT_NULL}"
			constKeys	= "KBCLM,SYSTEM_ID,TBLSYU,FGJ"
			constVals	= "0,{@MEM.SYSTEM_ID},{@MEM.TBLSYU},1"
		/>
	</og:tableUpdate>
</c:forTokens>

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
