<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2005"
	title	= "テーブルカラム定義マスタ"
	date	= "2014/05/16"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select	A.SYSTEM_ID,A.CLM,A.NAME_JA,A.CLS_NAME,
				A.USE_LENGTH,A.DATA_DEFAULT,
				A.RENDERER,A.EDITOR,A.DBTYPE,A.BIKO,A.FGJ,A.UNIQ
		from GF03 A
	<og:where>
		<og:and value = "A.FGJ         in  ('0','1')"			/>
		<og:and value = "A.SYSTEM_ID   =    '{@SYSTEM_ID}'"	/>
		<og:and value = "A.CLM         like '{@CLM}%'"			/>
		<og:and value = "A.NAME_JA     like '{@NAME_JA}%'"		/>
		<og:and value = "A.FGCOM       =    '{@FGCOM}'"		/>
		<og:and value = "A.CLS_NAME    =    '{@CLS_NAME}'"		/>
		<og:and value = "A.RENDERER    =    '{@RENDERER}'"		/>
		<og:and value = "A.EDITOR      =    '{@EDITOR}'"		/>
		<og:and value = "A.DBTYPE      =    '{@DBTYPE}'"		/>
		<og:and value = "A.USE_LENGTH  =    '{@USE_LENGTH}'"	/>
		<og:and value = "A.BIKO        like '{@BIKO}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.CLM" />
</og:query>



<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="null" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="null"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<og:hidden name="maxRowCount" value="{@maxRowCount}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
