/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* INDEX_BIKO ( FUNCTION )                                                  */
/* Created : 2014/05/21 18:36:26                                            */
/****************************************************************************/
CREATE FUNCTION INDEX_BIKO 
FUNCTION INDEX_BIKO (
	XSYSTEM_ID   IN VARCHAR2 ,
	XTBLSYU      IN VARCHAR2 ,
	XTABLE_NAME  IN VARCHAR2 ,
	XINDEX_NAME  IN VARCHAR2  )
RETURN VARCHAR2
/**********************************************************************/
/* インデックスの備考情報に、その定義情報をセットする。               */
/*  INDEX_BIKO( SYSTEM_ID,TBLSYU,TABLE_NAME,INDEX_NAME )              */
/*                                                                    */
/*	 SYSTEM_ID  in varchar2           システムID                      */
/*	 TBLSYU     in varchar2           テーブル種別                    */
/*	 TABLE_NAME in varchar2           テーブルID                      */
/*	 INDEX_NAME in varchar2           インデックスID                  */
/*                                                                    */
/*	データベースの縦型データを横型にします。                          */
/*                                                                    */
/**********************************************************************/
IS
    RTN     VARCHAR2(2000);

	CURSOR CODEC1 IS SELECT CLM
					FROM	GF07
					WHERE	SYSTEM_ID   = XSYSTEM_ID
					AND		TBLSYU      = XTBLSYU
					AND		TABLE_NAME  = XTABLE_NAME
					AND		INDEX_NAME  = XINDEX_NAME
					AND		FGJ			= '1'
					ORDER BY SEQNO;

	CODEREC CODEC1%ROWTYPE;

BEGIN
	RTN := '' ;

	OPEN	CODEC1;

	LOOP
		FETCH CODEC1 INTO CODEREC;
		EXIT WHEN CODEC1%NOTFOUND;

		RTN := RTN || CODEREC.CLM || ',' ;

	END LOOP;
	CLOSE CODEC1;

	RTN := SUBSTR( RTN,1,LENGTHB(RTN)-1 );

	RETURN RTN;

END INDEX_BIKO;
/
