/****************************************************************************/
/* GF85 ( 移行DB対応明細 )                                                  */
/*                                                                          */
/* Created : 2014/05/21 18:36:23                                            */
/****************************************************************************/
CREATE TABLE GF85 (
   T_SYSTEM_ID      VARCHAR2 (   10 )                   NOT NULL            /*  10 先ｼｽﾃﾑID     */
 , T_TABLE_NAME     VARCHAR2 (   50 )                   NOT NULL            /*  20 先ﾃｰﾌﾞﾙ名    */
 , T_CLM            VARCHAR2 (   30 )                   NOT NULL            /*  30 先項目       */
 , T_SEQNO          NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  40 先表示順     */
 , T_NAME_JA        VARCHAR2 (  200 )                                       /*  50 先名称       */
 , T_CLS_NAME       VARCHAR2 (   10 )                   NOT NULL            /*  60 先DBｸﾗｽ      */
 , T_USE_LENGTH     VARCHAR2 (    9 )                                       /*  70 先使用桁数   */
 , T_DATA_DEFAULT   VARCHAR2 (  200 )                                       /*  80 先初期値     */
 , T_NOT_NULL       VARCHAR2 (    1 )                                       /*  90 先ﾉｯﾄﾇﾙ      */
 , T_BIKO           VARCHAR2 ( 2000 )                                       /* 100 先備考       */
 , T_CONST          VARCHAR2 (  200 )                                       /* 110 先固定値     */
 , NOJUN            NUMBER   (    7 )       DEFAULT 0   NOT NULL            /* 120 対応順       */
 , CONV_FUNC        VARCHAR2 (  500 )                                       /* 130 変換関数     */
 , F_SYSTEM_ID      VARCHAR2 (   10 )                                       /* 140 元ｼｽﾃﾑID     */
 , F_TABLE_NAME     VARCHAR2 (   50 )                                       /* 150 元ﾃｰﾌﾞﾙ名    */
 , F_CLM            VARCHAR2 (   30 )                                       /* 160 元項目       */
 , F_SEQNO          NUMBER   (    7 )       DEFAULT 0   NOT NULL            /* 170 元表示順     */
 , F_NAME_JA        VARCHAR2 (  200 )                                       /* 180 元名称       */
 , F_CLS_NAME       VARCHAR2 (   10 )                                       /* 190 元DBｸﾗｽ      */
 , F_USE_LENGTH     VARCHAR2 (    9 )                                       /* 200 元使用桁数   */
 , F_BIKO           VARCHAR2 ( 2000 )                                       /* 210 元備考       */
 , BIKO             VARCHAR2 ( 2000 )                                       /* 220 備考         */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET            VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET           VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET           VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD            VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD           VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF85S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF85T00 
  BEFORE INSERT ON GF85
  FOR EACH ROW 
  BEGIN 
    SELECT GF85S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
