/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.QrcodeImage;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.ExecQueue;

public class OdsContentParser {
    private static final String BODY_START_TAG = "<table:table ";
    private static final String BODY_END_TAG = "</table:table>";
    private static final String ROW_START_TAG = "<table:table-row ";
    private static final String ROW_END_TAG = "</table:table-row>";
    private static final String ROW_START_TAG_INVISIBLE = "<table:table-row table:visibility=\"collapse\" ";
    private static final String SHEET_NAME_START = "table:name=\"";
    private static final String SHEET_NAME_END = "\"";
    private static final String OBJECT_SEARCH_STR = "table:end-cell-address=\"";
    private static final String PRINT_RANGE_START = "table:print-ranges=\"";
    private static final String PRINT_RANGE_END = "\"";
    private static final String FIRST_PAGE_NAME = "FIRST";
    private static final String VAL_START = "{@";
    private static final String VAR_END = "}";
    private static final String VAR_CON = "_";
    private static final String PAGE_END_CUT = "PAGEENDCUT";
    private static final String PAGE_BREAK = "PAGEBREAK";
    private static final String LINE_COPY = "LINECOPY";
    private static final String PAGE_NO = "PAGENO";
    private static final String ROW_NO = "ROWNO";
    private static final String DRAW_IMG_START_TAG = "<draw:image xlink:href=\"";
    private static final String DRAW_IMG_END_TAG = "</draw:image>";
    private static final String DRAW_IMG_HREF_END = "\"";
    private static final String IMG_DIR = "Pictures";
    private static final String QRCODE_PREFIX = "QRCODE.";
    private static final String QRCODE_FILETYPE = ".png";
    private static final String IMG_PREFIX = "IMG.";
    private static final String OOOC_FUNCTION_START = "oooc:=";
    private static final String OOOC_FUNCTION_START_3 = "of:=";
    private static final String OOOC_FUNCTION_END = ")\" ";
    private static final String OOO_CR = "</text:p><text:p>";
    private static final String TABLE_COUNT_START_TAG = "meta:table-count=\"";
    private static final String TABLE_COUNT_END_TAG = "\"";
    private static final String CELL_COUNT_START_TAG = "meta:cell-count=\"";
    private static final String CELL_COUNT_END_TAG = "\"";
    private static final String OBJECT_COUNT_START_TAG = "meta:object-count=\"";
    private static final String OBJECT_COUNT_END_TAG = "\"";
    private static final int NORMAL = 0;
    private static final int LASTROW = 1;
    private static final int OVERFLOW = 2;
    private int status = 0;
    private int currentBaseRow = 0;
    private int currentMaxRow = 0;
    private int pages = 0;
    private boolean isPageBreak = false;
    private String xmlHeader = null;
    private final ExecQueue queue;
    private final String path;

    OdsContentParser(ExecQueue execQueue, String string) {
        this.queue = execQueue;
        this.path = string;
        this.currentBaseRow = this.queue.getExecRowCnt();
    }

    public void exec() {
        this.execStyles();
        this.execContent();
        this.execMeta();
    }

    private void execContent() {
        String string = this.path + "content.xml";
        String string2 = this.readOOoXml(string);
        String[] stringArray = OdsContentParser.tag2Array(string2, BODY_START_TAG, BODY_END_TAG);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        ArrayList<OOoCalcSheet> arrayList = new ArrayList<OOoCalcSheet>();
        for (int i = 2; i < stringArray.length; ++i) {
            OOoCalcSheet oOoCalcSheet = new OOoCalcSheet();
            oOoCalcSheet.analyze(stringArray[i], this.queue.getBody().getRowCount());
            arrayList.add(oOoCalcSheet);
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(string);
            bufferedWriter.write(this.xmlHeader);
            bufferedWriter.write(10);
            bufferedWriter.write(string3);
            block6: for (OOoCalcSheet oOoCalcSheet : arrayList) {
                if (oOoCalcSheet.getSheetName().startsWith(FIRST_PAGE_NAME)) {
                    if (this.queue.getExecPagesCnt() != 0) continue;
                    this.writeParsedSheet(oOoCalcSheet, bufferedWriter);
                    continue;
                }
                while (this.currentBaseRow < this.queue.getBody().getRowCount()) {
                    if (this.pages >= 256) {
                        this.queue.setEnd(false);
                        continue block6;
                    }
                    this.writeParsedSheet(oOoCalcSheet, bufferedWriter);
                }
            }
            this.queue.addExecPageCnt(this.pages);
            this.queue.setExecRowCnt(this.currentBaseRow);
            bufferedWriter.write(string4);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:error occurer while write Parsed Sheet " + string + HybsSystem.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
        }
    }

    private void writeParsedSheet(OOoCalcSheet oOoCalcSheet, BufferedWriter bufferedWriter) throws IOException {
        String string = "Page" + (this.queue.getExecPagesCnt() + this.pages) + VAR_CON + "Row" + this.currentBaseRow + "";
        this.isPageBreak = false;
        String string2 = oOoCalcSheet.getHeader();
        int n = (string2 = string2.replace(SHEET_NAME_START + oOoCalcSheet.getSheetName(), SHEET_NAME_START + string)).indexOf(PRINT_RANGE_START);
        if (n >= 0) {
            int n2 = string2.indexOf("\"", n + PRINT_RANGE_START.length());
            String string3 = string2.substring(n, n2);
            string3 = string3.replace(oOoCalcSheet.getSheetName(), string);
            string2 = string2.substring(0, n) + string3 + string2.substring(n2);
        }
        bufferedWriter.write(string2);
        String[] stringArray = oOoCalcSheet.getRows();
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeParsedRow(stringArray[i], bufferedWriter, oOoCalcSheet.getSheetName(), string);
        }
        if (this.currentBaseRow == this.currentMaxRow) {
            this.queue.addMsg("[ERROR]PARSE:No Data defined on Template ODS(" + this.queue.getListId() + ")" + HybsSystem.CR);
            throw new HybsSystemException();
        }
        this.currentBaseRow = this.currentMaxRow;
        bufferedWriter.write(oOoCalcSheet.getFooter());
        ++this.pages;
    }

    private void writeParsedRow(String string, BufferedWriter bufferedWriter, String string2, String string3) throws IOException {
        String string4;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(VAL_START, n + 1)) >= 0) {
            stringBuilder.append(string.substring(n2, n));
            n2 = string.indexOf(VAR_END, n + 1) + VAR_END.length();
            if (n + VAL_START.length() > n2 - VAR_END.length()) {
                this.queue.addMsg("[ERROR]PARSE:{@\u3068}\u306e\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059\u3002" + HybsSystem.CR);
                throw new HybsSystemException();
            }
            string4 = string.substring(n + VAL_START.length(), n2 - VAR_END.length());
            int n3 = (string4 = OdsContentParser.checkKey(string4, stringBuilder)).indexOf(60);
            if (n3 >= 0) {
                this.queue.addMsg("[ERROR]PARSE:{@\u3068}\u306e\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059\u3002\u30ad\u30fc=" + string4.substring(0, n3) + HybsSystem.CR);
                throw new HybsSystemException();
            }
            if (string4.startsWith(QRCODE_PREFIX)) {
                n2 = this.makeQRImage(string, n2, string4.substring(QRCODE_PREFIX.length()), stringBuilder);
            } else if (string4.startsWith(IMG_PREFIX)) {
                n2 = this.changeImage(string, n2, string4.substring(IMG_PREFIX.length()), stringBuilder);
            }
            stringBuilder.append(this.getValue(string4));
            if (!this.queue.isFgcut() || !PAGE_END_CUT.equals(string4)) continue;
            bl = true;
        }
        stringBuilder.append(string.substring(n2, string.length()));
        string4 = null;
        string4 = bl && this.status == 2 ? stringBuilder.toString().replace(ROW_START_TAG, ROW_START_TAG_INVISIBLE) : stringBuilder.toString();
        if (string4.indexOf(OBJECT_SEARCH_STR) >= 0) {
            string4 = string4.replace(OBJECT_SEARCH_STR + string2, OBJECT_SEARCH_STR + string3);
        }
        string4 = this.replaceOoocError(string4);
        bufferedWriter.write(string4);
    }

    private String replaceOoocError(String string) {
        String string2 = null;
        int n = string.indexOf(OOOC_FUNCTION_START);
        int n2 = string.indexOf(OOOC_FUNCTION_START_3);
        if (n < 0 && n2 < 0) {
            return string;
        }
        string2 = n >= 0 ? OOOC_FUNCTION_START : OOOC_FUNCTION_START_3;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = -1;
        int n4 = 0;
        while ((n3 = string.indexOf(string2, n3 + 1)) >= 0) {
            stringBuilder.append(string.substring(n4, n3));
            n4 = string.indexOf(OOOC_FUNCTION_END, n3 + 1) + OOOC_FUNCTION_END.length();
            String string3 = string.substring(n3 + string2.length(), n4 - OOOC_FUNCTION_END.length() + 1);
            string3 = string3.replace("\"", "&quot;&quot;").replace(OOO_CR, "");
            stringBuilder.append(string2 + "IF(ISERROR(" + string3 + ");&quot;&quot;;" + string3 + OOOC_FUNCTION_END);
        }
        stringBuilder.append(string.substring(n4, string.length()));
        return stringBuilder.toString();
    }

    private int makeQRImage(String string, int n, String string2, StringBuilder stringBuilder) {
        int n2 = n;
        n2 = string.indexOf(DRAW_IMG_START_TAG, n2) + DRAW_IMG_START_TAG.length();
        stringBuilder.append(string.substring(n, n2));
        n2 = string.indexOf("\"", n2) + "\"".length();
        String string3 = "Pictures/" + string2 + VAR_CON + this.currentBaseRow + QRCODE_FILETYPE;
        stringBuilder.append(string3).append("\"");
        String string4 = this.getValue(string2);
        String string5 = new File(this.path).getAbsolutePath() + File.separator + IMG_DIR + File.separator + string2 + VAR_CON + this.currentBaseRow + QRCODE_FILETYPE;
        if (!new File(string5).getParentFile().exists() && new File(string5).getParentFile().mkdirs()) {
            System.err.println(string5 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        QrcodeImage qrcodeImage = new QrcodeImage();
        qrcodeImage.init(string4, string5);
        qrcodeImage.saveImage();
        return n2;
    }

    private int changeImage(String string, int n, String string2, StringBuilder stringBuilder) {
        int n2 = n;
        File file = null;
        String string3 = this.getValue(string2);
        if (string3 != null && string3.length() > 0) {
            file = new File(HybsSystem.url2dir(string3));
        }
        if (file != null && file.exists()) {
            n2 = string.indexOf(DRAW_IMG_START_TAG, n2) + DRAW_IMG_START_TAG.length();
            stringBuilder.append(string.substring(n, n2));
            n2 = string.indexOf("\"", n2) + "\"".length();
            String string4 = "Pictures/" + file.getName();
            stringBuilder.append(string4).append("\"");
            String string5 = new File(this.path).getAbsolutePath() + File.separator + IMG_DIR + File.separator + file.getName();
            if (!new File(string5).getParentFile().exists() && new File(string5).getParentFile().mkdirs()) {
                System.err.println(string5 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            FileUtil.copy((File)file, (File)new File(string5));
        } else {
            n2 = string.indexOf(DRAW_IMG_START_TAG, n2);
            stringBuilder.append(string.substring(n, n2));
            n2 = string.indexOf(DRAW_IMG_END_TAG, n2) + DRAW_IMG_END_TAG.length();
        }
        return n2;
    }

    private String getValue(String string) {
        int n = string.lastIndexOf(VAR_CON);
        String string2 = null;
        if (n < 0) {
            string2 = this.getHeaderFooterValue(string);
        } else {
            String string3 = string.substring(0, n);
            int n2 = -1;
            try {
                n2 = Integer.valueOf(string.substring(n + VAR_CON.length(), string.length())) + this.currentBaseRow;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = n2 < 0 ? this.getHeaderFooterValue(string) : this.getBodyValue(string3, n2);
        }
        return this.checkValue(string2);
    }

    private String getHeaderFooterValue(String string) {
        int n;
        String string2 = "";
        if (PAGE_NO.equals(string)) {
            string2 = String.valueOf(this.pages + 1);
        } else if (this.status >= 1) {
            int n2;
            if (this.queue.getFooter() != null && (n2 = this.queue.getFooter().getColumnNo(string, false)) >= 0) {
                string2 = (String)this.queue.getFooter().getValue(0, n2);
                if (this.queue.isFglocal()) {
                    string2 = this.queue.getFooter().getDBColumn(n2).getRendererValue(string2);
                }
            }
        } else if (this.queue.getHeader() != null && (n = this.queue.getHeader().getColumnNo(string, false)) >= 0) {
            string2 = (String)this.queue.getHeader().getValue(0, n);
            if (this.queue.isFglocal()) {
                string2 = this.queue.getHeader().getDBColumn(n).getRendererValue(string2);
            }
        }
        return string2;
    }

    private String getBodyValue(String string, int n) {
        if (this.isPageBreak) {
            return "";
        }
        int n2 = this.queue.getBody().getColumnNo(string, false);
        if (n2 < 0 && !ROW_NO.equals(string)) {
            return "";
        }
        if (PAGE_BREAK.equals(string)) {
            if (n <= this.queue.getBody().getRowCount() - 2 && !((String)this.queue.getBody().getValue(n, n2)).equals(this.queue.getBody().getValue(n + 1, n2))) {
                this.isPageBreak = true;
            }
            return "";
        }
        if (n >= this.queue.getBody().getRowCount()) {
            this.status = 2;
            return "";
        }
        if (n == this.queue.getBody().getRowCount() - 1) {
            this.status = Math.max(1, this.status);
        }
        String string2 = null;
        if (ROW_NO.equals(string)) {
            string2 = String.valueOf(n + 1);
        } else {
            string2 = (String)this.queue.getBody().getValue(n, n2);
            if (this.queue.isFglocal()) {
                string2 = this.queue.getBody().getDBColumn(n2).getRendererValue(string2);
            }
        }
        if (this.currentMaxRow < n + 1) {
            this.currentMaxRow = n + 1;
        }
        return string2;
    }

    private static String checkKey(String string, StringBuilder stringBuilder) {
        if (string.indexOf(60) < 0 && string.indexOf(62) < 0) {
            return string;
        }
        String string2 = string;
        String string3 = ">";
        String string4 = "<text:a ";
        String string5 = "</text:a>";
        if (string.indexOf(string5) >= 0) {
            string2 = string2.replace(string5, "");
            int n = stringBuilder.lastIndexOf(string4);
            int n2 = stringBuilder.indexOf(string3, n);
            stringBuilder.delete(n, n2 + string3.length());
        }
        return string2;
    }

    private String checkValue(String string) {
        String string2 = string;
        if (this.queue.isFglocal()) {
            int n = -1;
            n = string2.indexOf("<span");
            if (n >= 0) {
                String string3 = string2.substring(n, string2.indexOf(62, n) + 1);
                string2 = string2.replace(string3, "").replace("</span>", "");
            }
        }
        if (string2.indexOf(38) >= 0) {
            string2 = string2.replace("&", "&amp;");
        }
        if (string2.indexOf(60) >= 0) {
            string2 = string2.replace("<", "&lt;");
        }
        if (string2.indexOf(62) >= 0) {
            string2 = string2.replace(">", "&gt;");
        }
        if (string2.indexOf("\n") >= 0) {
            string2 = string2.replace("\r\n", "\n").replace("\n", OOO_CR);
        }
        return string2;
    }

    private static String[] tag2Array(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        int n2 = 0;
        while (true) {
            if ((n2 = string.indexOf(string2, n + 1)) < 0) break;
            if (n == -1) {
                string4 = string.substring(0, n2);
            } else {
                arrayList.add(string.substring(n, n2));
            }
            n = n2;
        }
        n2 = string.lastIndexOf(string3) + string3.length();
        arrayList.add(string.substring(n, n2));
        string5 = string.substring(n2);
        String[] stringArray = new String[arrayList.size() + 2];
        stringArray[0] = string4;
        stringArray[1] = string5;
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i + 2] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    protected static String getValueFromTag(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(string3, n += string2.length());
        String string4 = string.substring(n, n2);
        return string4;
    }

    private void execStyles() {
        String string = this.path + "styles.xml";
        String string2 = this.readOOoXml(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        int n2 = 0;
        while ((n = string2.indexOf(VAL_START, n + 1)) >= 0) {
            stringBuilder.append(string2.substring(n2, n));
            n2 = string2.indexOf(VAR_END, n + 1) + VAR_END.length();
            String string3 = string2.substring(n + VAL_START.length(), n2 - VAR_END.length());
            stringBuilder.append(this.getHeaderFooterValue(string3));
        }
        stringBuilder.append(string2.substring(n2, string2.length()));
        this.writeOOoXml(string, stringBuilder.toString());
    }

    private void execMeta() {
        String string;
        String string2 = this.path + "meta.xml";
        String string3 = this.readOOoXml(string2);
        if (string3.indexOf(TABLE_COUNT_START_TAG) >= 0) {
            string = OdsContentParser.getValueFromTag(string3, TABLE_COUNT_START_TAG, "\"");
            string3 = string3.replace(TABLE_COUNT_START_TAG + string, TABLE_COUNT_START_TAG + String.valueOf(this.pages));
        }
        if (string3.indexOf(CELL_COUNT_START_TAG) >= 0) {
            string = OdsContentParser.getValueFromTag(string3, CELL_COUNT_START_TAG, "\"");
            string3 = string3.replace(CELL_COUNT_START_TAG + string, CELL_COUNT_START_TAG + String.valueOf(Integer.parseInt(string) * this.pages));
        }
        if (string3.indexOf(OBJECT_COUNT_START_TAG) >= 0 && (string = OdsContentParser.getValueFromTag(string3, OBJECT_COUNT_START_TAG, "\"")) != null) {
            string3 = string3.replace(OBJECT_COUNT_START_TAG + string, OBJECT_COUNT_START_TAG + String.valueOf(Integer.parseInt(string) * this.pages));
        }
        this.writeOOoXml(string2, string3);
    }

    private String readOOoXml(String string) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            this.xmlHeader = bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (IOException iOException) {
            try {
                this.queue.addMsg("[ERROR]PARSE:Failed to read " + string + HybsSystem.CR);
                throw new HybsSystemException(iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)bufferedReader);
        String string3 = stringBuilder.toString();
        if (this.xmlHeader == null || this.xmlHeader.length() == 0 || string3 == null || string3.length() == 0) {
            this.queue.addMsg("[ERROR]PARSE:Maybe " + string + " is Broken!" + HybsSystem.CR);
            throw new HybsSystemException();
        }
        return string3;
    }

    private void writeOOoXml(String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(string);
            bufferedWriter.write(this.xmlHeader);
            bufferedWriter.write(10);
            bufferedWriter.write(string2);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:Failed to write " + string + HybsSystem.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
        }
    }

    private BufferedWriter getWriter(String string) {
        BufferedWriter bufferedWriter;
        File file = new File(string);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.queue.addMsg("[ERROR] Input File is written by Unsupported Encoding");
            throw new HybsSystemException(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.queue.addMsg("[ERROR] File not Found");
            throw new HybsSystemException(fileNotFoundException);
        }
        return bufferedWriter;
    }

    private static class OOoCalcSheet {
        private String sheetHeader;
        private List<String> sheetRows = new ArrayList<String>();
        private String sheetFooter;
        private String sheetName;

        private OOoCalcSheet() {
        }

        public void analyze(String string, int n) {
            String[] stringArray = OdsContentParser.tag2Array(string, OdsContentParser.ROW_START_TAG, OdsContentParser.ROW_END_TAG);
            this.sheetHeader = stringArray[0];
            this.sheetFooter = stringArray[1];
            for (int i = 2; i < stringArray.length; ++i) {
                this.sheetRows.add(stringArray[i]);
                this.lineCopy(stringArray[i], n);
            }
            this.sheetName = OdsContentParser.getValueFromTag(this.sheetHeader, OdsContentParser.SHEET_NAME_START, "\"");
        }

        private void lineCopy(String string, int n) {
            StringBuilder stringBuilder;
            int n2 = -1;
            int n3 = -1;
            n2 = string.indexOf("{@LINECOPY");
            if (n2 < 0) {
                return;
            }
            n3 = string.indexOf(OdsContentParser.VAR_END, n2);
            String string2 = string.substring(n2 + OdsContentParser.VAL_START.length(), n3);
            if (OdsContentParser.LINE_COPY.equals(OdsContentParser.checkKey(string2, stringBuilder = new StringBuilder(string)))) {
                for (int i = 1; i < n; ++i) {
                    stringBuilder = new StringBuilder();
                    n2 = -1;
                    n3 = 0;
                    while ((n2 = string.indexOf(OdsContentParser.VAL_START, n2 + 1)) >= 0) {
                        stringBuilder.append(string.substring(n3, n2));
                        n3 = string.indexOf(OdsContentParser.VAR_END, n2 + 1) + OdsContentParser.VAR_END.length();
                        String string3 = string.substring(n2 + OdsContentParser.VAL_START.length(), n3 - OdsContentParser.VAR_END.length());
                        string3 = OdsContentParser.checkKey(string3, stringBuilder);
                        int n4 = string3.indexOf(60);
                        if (n4 >= 0) {
                            return;
                        }
                        stringBuilder.append(OdsContentParser.VAL_START).append(this.incrementKey(string3, i)).append(OdsContentParser.VAR_END);
                    }
                    stringBuilder.append(string.substring(n3, string.length()));
                    this.sheetRows.add(stringBuilder.toString());
                }
            }
        }

        private String incrementKey(String string, int n) {
            int n2 = string.lastIndexOf(OdsContentParser.VAR_CON);
            String string2 = null;
            if (n2 < 0) {
                string2 = string;
            } else {
                String string3 = string.substring(0, n2);
                int n3 = -1;
                try {
                    n3 = Integer.valueOf(string.substring(n2 + OdsContentParser.VAR_CON.length(), string.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string2 = n3 < 0 ? string : string3 + OdsContentParser.VAR_CON + (n3 + n);
            }
            return string2;
        }

        public String getHeader() {
            return this.sheetHeader;
        }

        public String getFooter() {
            return this.sheetFooter;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public String[] getRows() {
            return this.sheetRows.toArray(new String[this.sheetRows.size()]);
        }
    }
}

