/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.ProcessFactory;
import org.opengion.hayabusa.report2.SOfficeProcess;

public class DocConverter {
    private final String inputName;
    private final boolean isOnline;
    private XComponent doc;
    private SOfficeProcess soffice;
    private static final HashMap<String, String> filterMap = new HashMap();

    public DocConverter(String string) {
        this(string, true);
    }

    public DocConverter(String string, boolean bl) {
        this.inputName = string;
        this.isOnline = bl;
        if (this.inputName == null || this.inputName.length() == 0) {
            throw new HybsSystemException("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        File file = new File(this.inputName);
        if (!file.exists()) {
            throw new HybsSystemException("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[file=" + this.inputName + "]");
        }
    }

    public void open() throws Throwable {
        if (this.isOnline) {
            this.soffice = ProcessFactory.newInstance();
        } else {
            this.soffice = new SOfficeProcess("docconverter.class");
            this.soffice.bootstrap();
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Hidden";
        propertyValueArray[0].Value = true;
        String string = "file:///" + this.inputName.replace('\\', '/');
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.soffice.getDesktop());
        try {
            this.doc = xComponentLoader.loadComponentFromURL(string, "_default", 0, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u5165\u51fa\u529b\u30a8\u30e9\u30fc)\u3002", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u4e0d\u6b63)\u3002", illegalArgumentException);
        }
    }

    public void close() throws Throwable {
        this.close(false);
    }

    public void close(boolean bl) {
        if (this.doc != null) {
            XCloseable xCloseable = null;
            int n = 0;
            while (true) {
                try {
                    xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.doc);
                    xCloseable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    if (n == 600) {
                        throw new HybsSystemException("soffice\u30d7\u30ed\u30bb\u30b9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002", closeVetoException);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new HybsSystemException(interruptedException);
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        if (this.soffice != null) {
            if (this.isOnline) {
                if (bl) {
                    ProcessFactory.remove(this.soffice);
                } else {
                    ProcessFactory.release(this.soffice);
                }
            } else {
                this.soffice.close();
            }
        }
    }

    public void print(String string) throws Throwable {
        if (this.doc == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (string == null || string.length() == 0) {
            throw new HybsSystemException("\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.doc);
        XPrintJobBroadcaster xPrintJobBroadcaster = (XPrintJobBroadcaster)UnoRuntime.queryInterface(XPrintJobBroadcaster.class, (Object)xPrintable);
        MyPrintJobListener myPrintJobListener = new MyPrintJobListener();
        xPrintJobBroadcaster.addPrintJobListener((XPrintJobListener)myPrintJobListener);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Name";
        propertyValueArray[0].Value = "LINUX".indexOf(HybsSystem.sys("OS_INFO").toUpperCase(Locale.JAPAN)) >= 0 ? "<" + string + ">" : string;
        try {
            xPrintable.setPrinter(propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        String string2 = null;
        PropertyValue[] propertyValueArray2 = xPrintable.getPrinter();
        for (int i = 0; i < propertyValueArray2.length; ++i) {
            if (!"Name".equals(propertyValueArray2[i].Name)) continue;
            string2 = (String)propertyValueArray2[i].Value;
            break;
        }
        if (!string.equalsIgnoreCase(string2)) {
            String string3 = "\u30d7\u30ea\u30f3\u30bf\u30fc[" + string + "]\u3092\u767a\u884c\u5148\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u5b58\u5728\u3057\u306a\u3044\u30d7\u30ea\u30f3\u30bf\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002";
            throw new HybsSystemException(string3);
        }
        PropertyValue[] propertyValueArray3 = new PropertyValue[]{new PropertyValue()};
        propertyValueArray3[0].Name = "Wait";
        propertyValueArray3[0].Value = true;
        try {
            xPrintable.print(propertyValueArray3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        if (myPrintJobListener.getStatus() == null || myPrintJobListener.getStatus() != PrintableState.JOB_COMPLETED && myPrintJobListener.getStatus() != PrintableState.JOB_SPOOLED) {
            throw new HybsSystemException("Error Occured while spooling print job. Check Spooler-Service!!!");
        }
    }

    public void pdf(String string, String string2) throws Throwable {
        this.savePdf(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "pdf"), string2);
    }

    public void ods(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "ods"));
    }

    public void xls(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "xls"));
    }

    public void odt(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "odt"));
    }

    public void doc(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "doc"));
    }

    public void odp(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "odp"));
    }

    public void ppt(String string) throws Throwable {
        this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), "ppt"));
    }

    public void auto(String string) throws Throwable {
        String string2 = DocConverter.getSuffix(string);
        if ("pdf".equalsIgnoreCase(string2)) {
            this.savePdf(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), string2), null);
        } else {
            this.saveDoc(string, DocConverter.getFilterName(DocConverter.getSuffix(this.inputName), string2));
        }
    }

    private void saveDoc(String string, String string2) {
        if (this.doc == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (!this.checkOutput(string)) {
            return;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = string2;
        String string3 = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.doc);
        try {
            xStorable.storeAsURL(string3, propertyValueArray);
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[filter=" + string2 + "]", throwable);
        }
    }

    private void savePdf(String string, String string2, String string3) {
        Object object;
        PropertyValue[] propertyValueArray;
        if (this.doc == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (!this.checkOutput(string)) {
            return;
        }
        if (string3 == null || string3.length() == 0) {
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = string2;
        } else {
            object = new PropertyValue[2];
            object[0] = new PropertyValue();
            object[0].Name = "EncryptFile";
            object[0].Value = true;
            object[1] = new PropertyValue();
            object[1].Name = "DocumentOpenPassword";
            object[1].Value = string3;
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "calc_pdf_Export";
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "FilterData";
            propertyValueArray[1].Value = object;
        }
        object = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.doc);
        try {
            xStorable.storeToURL((String)object, propertyValueArray);
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("PDF\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[filter=" + string2 + "]", throwable);
        }
    }

    private boolean checkOutput(String string) {
        if (string == null || string.length() == 0) {
            throw new HybsSystemException("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        File file = new File(this.inputName);
        File file2 = new File(string);
        if (file2.exists()) {
            if (file.getAbsoluteFile().equals(file2.getAbsoluteFile())) {
                return false;
            }
            if (!file2.delete()) {
                throw new HybsSystemException("\u51fa\u529b\u5148\u306e\u65e2\u5b58\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002[file=" + string + "]");
            }
        }
        return true;
    }

    private static String getFilterName(String string, String string2) {
        String string3 = filterMap.get(string + "_" + string2);
        if (string3 == null) {
            String string4 = "\u5165\u529b\u5f62\u5f0f\u3001\u51fa\u529b\u5f62\u5f0f\u306f\u3001\u4ee5\u4e0b\u306e\u5bfe\u5fdc\u8868\u306b\u57fa\u3065\u304d\u3001\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002" + HybsSystem.CR + "\u5165\u529b[Calc(ods)   ,Excel(xls)     ] -> \u51fa\u529b[Calc(ods)   ,Excel(xls)     ,PDF]" + HybsSystem.CR + "\u5165\u529b[Writer(odt) ,Word(doc)      ] -> \u51fa\u529b[Writer(odt) ,Word(doc)      ,PDF]" + HybsSystem.CR + "\u5165\u529b[Impress(odp),PowerPoint(ppt)] -> \u51fa\u529b[Impress(odp),PowerPoint(ppt),PDF]" + HybsSystem.CR;
            throw new HybsSystemException(string4);
        }
        return string3;
    }

    private static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    public static final void convert(String string, String string2) {
        DocConverter.convert(string, string2, true);
    }

    public static final void convert(String string, String string2, boolean bl) {
        DocConverter docConverter = new DocConverter(string, bl);
        try {
            docConverter.open();
            docConverter.auto(string2);
            docConverter.close();
        }
        catch (Throwable throwable) {
            docConverter.close(true);
            throw new HybsSystemException(throwable);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage : OdsConverter [inputFile or inputDir] [outputDir]");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (file2.mkdirs()) {
            System.err.println(stringArray[1] + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsolutePath().endsWith(".xls")) continue;
                String string = fileArray[i].getAbsolutePath();
                String string2 = file2.getAbsolutePath() + File.separator + fileArray[i].getName().replace(".xls", ".ods");
                DocConverter.convert(string, string2, false);
            }
        } else if (file.getAbsolutePath().endsWith(".xls")) {
            String string = file.getAbsolutePath();
            String string3 = file2.getAbsolutePath() + File.separator + file.getName().replace(".xls", ".ods");
            DocConverter.convert(string, string3, false);
        }
    }

    static {
        filterMap.put("ods_ods", "calc8");
        filterMap.put("xls_ods", "calc8");
        filterMap.put("ods_xls", "MS Excel 97");
        filterMap.put("xls_xls", "MS Excel 97");
        filterMap.put("ods_pdf", "calc_pdf_Export");
        filterMap.put("xls_pdf", "calc_pdf_Export");
        filterMap.put("odt_odt", "writer8");
        filterMap.put("doc_odt", "writer8");
        filterMap.put("odt_doc", "MS Word 97");
        filterMap.put("doc_doc", "MS Word 97");
        filterMap.put("odt_pdf", "writer_pdf_Export");
        filterMap.put("doc_pdf", "writer_pdf_Export");
        filterMap.put("odp_odp", "impress8");
        filterMap.put("ppt_odp", "impress8");
        filterMap.put("odp_ppt", "MS PowerPoint 97");
        filterMap.put("ppt_ppt", "MS PowerPoint 97");
        filterMap.put("odp_pdf", "impress_pdf_Export");
        filterMap.put("ppt_pdf", "impress_pdf_Export");
    }

    private static class MyPrintJobListener
    implements XPrintJobListener {
        private PrintableState status = null;

        private MyPrintJobListener() {
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            this.status = printJobEvent.State;
        }

        public void disposing(EventObject eventObject) {
        }

        public PrintableState getStatus() {
            return this.status;
        }
    }
}

