/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.util.ArrayList;
import oaks.Field;

public class Where {
    private RO ope = null;
    private Field fld = null;
    private Field.GRP grp = null;
    private LO logi = null;
    private Where[] wh = null;
    private STR str_cond = null;

    public static Where makeAndEq(Field ... field) {
        switch (field.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new Where(RO.EQ, field[0]);
            }
        }
        ArrayList<Where> list = new ArrayList<Where>();
        for (Field f : field) {
            list.add(new Where(RO.EQ, f));
        }
        return new Where(LO.AND, list.toArray(new Where[0]));
    }

    public Where(RO relational, Field field) {
        this.ope = relational;
        this.fld = field;
    }

    public Where(RO relational, Field field, Field.GRP group) {
        this(relational, field);
        this.grp = group;
    }

    public Where(LO logical, Where ... where) {
        this.logi = logical;
        ArrayList<Where> list = new ArrayList<Where>();
        for (Where w : where) {
            if (w == null) continue;
            list.add(w);
        }
        this.wh = list.size() == 0 ? null : list.toArray(new Where[0]);
    }

    public Where(STR str, Likeable field) {
        this.str_cond = str;
        this.fld = (Field)((Object)field);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean flag = false;
        if (this.logi != null && this.wh != null) {
            buf = buf.append("(");
            for (int i = 0; i < this.wh.length; ++i) {
                String ret = this.wh[i].toString();
                if (ret == null) continue;
                if (!flag) {
                    flag = true;
                } else {
                    buf = buf.append(this.logi.str);
                }
                buf = buf.append(ret);
            }
            buf = buf.append(")");
        } else if (this.fld != null) {
            Object obj = this.fld.getObject();
            if (obj == Field.NO_CARE) {
                return null;
            }
            buf = buf.append(this.grp == null ? this.fld.getName() : this.fld.toString(this.grp));
            if (this.ope != null) {
                flag = true;
                buf = obj != null ? buf.append(this.ope.str).append("?") : buf.append(this.ope == RO.EQ ? " IS NULL" : " IS NOT NULL");
            } else if (this.str_cond != null && obj != null) {
                flag = true;
                buf = buf.append(this.str_cond.str).append("?");
            }
        }
        return flag ? buf.toString() : null;
    }

    String getString(boolean where_f) {
        StringBuilder buf = new StringBuilder(where_f ? " where " : " having ");
        String ret = this.toString();
        if (ret == null) {
            return "";
        }
        return buf.append(ret).toString();
    }

    private ArrayList<Object> getParam(ArrayList<Object> list) {
        if (this.wh != null) {
            for (int i = 0; i < this.wh.length; ++i) {
                list = this.wh[i].getParam(list);
            }
            return list;
        }
        if (this.fld == null) {
            return list;
        }
        Object obj = this.fld.getObject();
        if (obj == null || obj == Field.NO_CARE) {
            return list;
        }
        list.add(obj);
        return list;
    }

    Object[] getParam() {
        return this.getParam(new ArrayList<Object>()).toArray(new Object[0]);
    }

    public static interface Likeable {
    }

    public static enum STR {
        LIKE(" like "),
        NOT_LIKE(" not like ");

        private String str;

        private STR(String s) {
            this.str = s;
        }
    }

    public static enum LO {
        AND(" and "),
        OR(" or ");

        private String str;

        private LO(String s) {
            this.str = s;
        }
    }

    public static enum RO {
        EQ("="),
        NE("<>"),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private String str;

        private RO(String s) {
            this.str = s;
        }
    }
}

