/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oaks.DB;
import oaks.Field;
import oaks.Record;
import oaks.SelectGroup;
import oaks.View;

public class SelectList<E extends View>
extends Thread
implements Iterable<E>,
Serializable,
DB.Resource {
    private static final long serialVersionUID = 1L;
    private static int LIMIT = 1000;
    private Record<E> list = null;
    private transient View view = null;
    private transient SelectGroup sg = null;
    private transient ResultSet rs = null;
    private transient DB mydb;
    private volatile transient DB.DBException ex = null;
    private volatile transient boolean end_f = true;
    private volatile int size = 0;
    private Class<?> me;
    private transient ArrayList<Field.GRP[]> org_grp = new ArrayList();

    public static void setOnMemoryLimit(int limit) {
        if (limit < 5) {
            limit = 5;
        }
        LIMIT = limit;
    }

    public static int getOnMemoryLimit() {
        return LIMIT;
    }

    private SelectList() {
    }

    SelectList(DB db, SelectGroup sel) {
        this.mydb = db;
        this.mydb.addResource(this);
        this.sg = sel;
        this.list = new Record(LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Record<E> record = this.list;
        synchronized (record) {
            while (!this.end_f) {
                try {
                    this.list.wait(1000L);
                }
                catch (Exception exception) {}
            }
        }
        stream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(int index) throws DB.DBException {
        if (index < 0) {
            return null;
        }
        this.waitClose(index + 1);
        Record<E> record = this.list;
        synchronized (record) {
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.size > index) {
                return this.list.get(this.me, index);
            }
        }
        return null;
    }

    public boolean isClosed() throws DB.DBException {
        if (this.ex != null) {
            throw this.ex;
        }
        return this.end_f;
    }

    @Override
    public void waitClose() throws DB.DBException {
        this.waitClose(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitClose(int s) throws DB.DBException {
        int ms = 1;
        while (!(this.end_f || s <= this.size && s > 0)) {
            Record<E> record = this.list;
            synchronized (record) {
                try {
                    this.list.wait(ms);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ms >= 50) continue;
            ms <<= 1;
        }
        if (this.ex != null) {
            throw this.ex;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Next(this);
    }

    public int size() throws DB.DBException {
        if (this.ex != null) {
            throw this.ex;
        }
        this.waitClose();
        return this.size;
    }

    void start(View v, ResultSet r) {
        this.view = v;
        this.me = v.getClass();
        for (Field f : v.getFields()) {
            this.org_grp.add(f.getGroup());
        }
        this.rs = r;
        this.end_f = false;
        this.setDaemon(true);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.view == null) return;
        if (this.rs == null) {
            return;
        }
        try {
            while (this.rs.next()) {
                View v = View.newInstance(this.view.getClass());
                v.setName(this.view.getName());
                Field[] fld = v.getFields();
                for (int i = 0; i < fld.length; ++i) {
                    fld[i].setGroup(this.org_grp.get(i));
                }
                this.sg.set(v, this.rs);
                Record<E> record = this.list;
                synchronized (record) {
                    this.list.add(v);
                    ++this.size;
                    this.list.notifyAll();
                }
            }
            return;
        }
        catch (DB.DBException dbe) {
            this.ex = dbe;
            return;
        }
        catch (SQLException e) {
            this.ex = new DB.SQLExecException(this.mydb, e);
            return;
        }
        finally {
            try {
                this.rs.close();
                ResultSet dbe = this.rs;
                synchronized (dbe) {
                    this.rs.notify();
                }
            }
            catch (Exception e) {}
            this.view = null;
            this.mydb = null;
            this.rs = null;
            this.sg = null;
            this.end_f = true;
        }
    }

    private class Next
    implements Iterator<E> {
        private SelectList<E> list;
        private int count = 0;

        private Next(SelectList<E> sl) {
            this.list = sl;
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public E next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                ++this.count;
                return this.list.get(this.count - 1);
            }
            catch (DB.DBException e) {
                throw new NoSuchElementException(e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.list.waitClose(this.count + 1);
                return this.list.size() > this.count;
            }
            catch (DB.DBException e) {
                return true;
            }
        }
    }
}

