/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.Serializable;
import java.util.HashMap;

public abstract class Field<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Object NO_CARE = new Object();
    private static HashMap<Class<? extends Field>, String> map = new HashMap();
    private String name;
    private Object data = NO_CARE;
    private HashMap<GRP, Object> grp = null;

    public abstract MetaData getMetaData();

    static String toString(GRP _grp, Class<? extends Field> f) {
        StringBuilder buf = new StringBuilder(((Object)_grp).toString());
        buf = buf.append("(").append(Field.getName(f));
        buf = buf.append(")");
        return buf.toString();
    }

    String toString(GRP _grp) {
        return Field.toString(_grp, this.getClass());
    }

    GRP[] getGroup() {
        if (this.grp == null) {
            return null;
        }
        return this.grp.keySet().toArray(new GRP[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(Class<? extends Field> cl, String n) {
        HashMap<Class<? extends Field>, String> hashMap = map;
        synchronized (hashMap) {
            map.put(cl, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getName(Class<? extends Field> cl) {
        HashMap<Class<? extends Field>, String> hashMap = map;
        synchronized (hashMap) {
            return map.get(cl);
        }
    }

    private Field() {
    }

    protected Field(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    Object getObject() {
        return this.data;
    }

    public E get() {
        if (this.data == NO_CARE) {
            return null;
        }
        return this.convert(this.data);
    }

    public String getString() {
        E ret = this.get();
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public void set(E v) {
        this.data = this.toObject(v);
    }

    public void setFrom(Field<E> v) {
        this.set(v.get());
    }

    protected E convert(Object obj) {
        return (E)obj;
    }

    protected Object toObject(E v) {
        return v;
    }

    public void setGroup(GRP ... function) {
        if (function == null) {
            this.grp = null;
            return;
        }
        int cnt = function.length;
        if (cnt == 0) {
            this.grp = null;
            return;
        }
        HashMap<GRP, Object> g = new HashMap<GRP, Object>();
        for (int i = 0; i < cnt; ++i) {
            g.put(function[i], null);
        }
        this.grp = g;
    }

    public E getGroup(SameGRP function) {
        if (this.grp == null) {
            return null;
        }
        return this.convert(this.grp.get(function));
    }

    public Integer getGroup(NumberGRP function) {
        if (this.grp == null) {
            return null;
        }
        return new Integer(this.grp.get(function).toString());
    }

    void setObject(GRP function, Object obj) {
        if (function == null || this.grp == null) {
            this.data = obj;
        } else {
            this.grp.put(function, obj);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf = buf.append(" = ");
        if (this.data == null) {
            buf = buf.append("null");
        } else if (this.data == NO_CARE) {
            buf = buf.append("not initialized");
        } else {
            buf = buf.append("[").append(this.data.getClass().toString()).append("][");
            buf = buf.append(this.data.toString()).append("]");
        }
        return buf.toString();
    }

    public static enum SameGRP implements GRP
    {
        MIN("min"),
        MAX("max"),
        SUM("sum");

        private String str;

        private SameGRP(String s) {
            this.str = s;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum NumberGRP implements GRP
    {
        COUNT("count");

        private String str;

        private NumberGRP(String s) {
            this.str = s;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static interface GRP {
        public String toString();
    }

    public static class MetaData {
        private Class<?> cls;
        private int len;
        private int scale;

        public MetaData(Class<?> c, int p, int s) {
            this.cls = c;
            this.len = p;
            this.scale = s;
        }

        public Class<?> getSQLClass() {
            return this.cls;
        }

        public boolean isNumber() {
            return Number.class.isAssignableFrom(this.cls);
        }

        public boolean isString() {
            return String.class.isAssignableFrom(this.cls);
        }

        public int getPrecision() {
            return this.len;
        }

        public int getScale() {
            return this.scale;
        }
    }
}

