/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import oaks.CallCollect;
import oaks.analysis.Collecter;
import oaks.analysis.SqlInformation;

public class ConnectionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer DEF_MAX = 20;
    private static final Integer DEF_TIMEOUT = 15;
    private static volatile HashMap<ConnectionKey, Integer> max = new HashMap();
    private static volatile HashMap<ConnectionKey, Integer> timeout = new HashMap();
    private int hash;
    private String driver = null;
    private String url;
    private String user;
    private String passwd;
    private CallCollect[] collect = new CallCollect[0];

    void put(SqlInformation info) {
        for (CallCollect c : this.collect) {
            c.put(info);
        }
    }

    public void setCollecter(Collecter ... collecter) {
        if (collecter == null || collecter.length == 0) {
            this.collect = new CallCollect[0];
            return;
        }
        this.collect = new CallCollect[collecter.length];
        for (int i = 0; i < collecter.length; ++i) {
            this.collect[i] = new CallCollect(collecter[i]);
        }
    }

    private ConnectionKey() {
    }

    public ConnectionKey(String ur, String us, String pw) {
        this.url = ur;
        this.user = us;
        this.passwd = pw;
        StringBuilder buf = new StringBuilder(this.url);
        this.hash = buf.append("<oaks>").append(this.user).toString().hashCode();
        this.getMaxConnect();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        buf = buf.append(this.url).append("][").append(this.user).append("]");
        return buf.toString();
    }

    public ConnectionKey(String jdbc, String ur, String us, String pw) {
        this(ur, us, pw);
        this.driver = jdbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnect(int count) {
        HashMap<ConnectionKey, Integer> hashMap = max;
        synchronized (hashMap) {
            max.put(this, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnect() {
        Integer count = null;
        HashMap<ConnectionKey, Integer> hashMap = max;
        synchronized (hashMap) {
            count = max.get(this);
            if (count == null || count < 1) {
                count = DEF_MAX;
                max.put(this, count);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int sec) {
        HashMap<ConnectionKey, Integer> hashMap = timeout;
        synchronized (hashMap) {
            timeout.put(this, sec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() {
        Integer sec = null;
        HashMap<ConnectionKey, Integer> hashMap = timeout;
        synchronized (hashMap) {
            sec = timeout.get(this);
            if (sec == null || sec < 1) {
                sec = DEF_TIMEOUT;
                timeout.put(this, sec);
            }
        }
        return sec;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionKey)) {
            return false;
        }
        ConnectionKey key = (ConnectionKey)o;
        return this.url.equals(key.url) && this.user.equals(key.user);
    }

    public int hashCode() {
        return this.hash;
    }

    Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.driver != null) {
            Class.forName(this.driver);
        }
        Connection con = DriverManager.getConnection(this.url, this.user, this.passwd);
        con.setAutoCommit(false);
        return con;
    }
}

