/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaState;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ReplaceAction;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;

public class NinaTranslatorC
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");

    private String tostr(int c) {
        String x = c == 92 ? "'\\\\'" : (c == 10 ? "'\\n'" : (c == 39 ? "'\\''" : (Character.isISOControl(c) ? Integer.toString(c) : (c < 65535 ? String.format("'%c'", Character.valueOf((char)c)) : Integer.toString(c)))));
        return x;
    }

    private void printintv(PrintStream out, Interval v, boolean els) {
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t} else if" : "\t\tif";
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String x = this.tostr(c);
        String y = this.tostr(d);
        if (v.isClosed() && c == d) {
            out.format("%s(__c__ == %s) {\n", a, x);
        } else {
            out.format("%s(__c__ %s %s && __c__ %s %s) {\n", a, s, x, t, y);
        }
    }

    private String outln(boolean els, PrintStream out) {
        if (els) {
            out.println("\t\t\t} else {");
            return "\t";
        }
        return "";
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        DFABuilder.DBS b;
        Object o;
        boolean els = false;
        boolean el2 = true;
        boolean[] z = new boolean[1];
        int sn = this.getStateNo(dfa);
        out.format("\tcase %d:\n", sn);
        for (Interval v : dfa.getAlphabetRanges()) {
            this.printintv(out, v, els);
            int c = (Integer)v.getInfimumBound();
            if (v.isInfimumOpen()) {
                ++c;
            }
            if ((o = dfa.getLabelInt(c)) != null) {
                out.format("\t\t\t\t%s\n", ReplaceAction.replace(o.toString(), z, this, this.getStateNo(dfa), this.builder.getLabelByState(dfa)));
            }
            DFAState<Object, ?, Void> d = dfa.goInt(c);
            out.format("\t\t\t__o__->state = %d;\n", this.getStateNo(d));
            out.println("\t\t\treturn 1;");
            els = true;
        }
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            if (els) {
                out.println("\t\t\t} else if(__c__ < 0) {");
            } else {
                out.println("\t\t\tif(__c__ < 0) {");
            }
            o = ((DFABuilder.DBS)dfa).getMealyEnd();
            if (o != null) {
                out.format("\t\t\t\t%s\n", ReplaceAction.replace(o.toString(), z, this, this.getStateNo(dfa), this.builder.getLabelByState(dfa)));
            }
            out.format("\t\t\t\t__o__->state = %d;\n", this.getStateNo(b));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        }
        if (dfa instanceof DFABuilder.DBS) {
            DFABuilder.DBS a = (DFABuilder.DBS)dfa;
            b = a.getOthers();
            if (b != null) {
                String s = this.outln(els, out);
                o = a.getMealyOthers();
                if (o != null) {
                    out.format("%s\t\t\t%s\n", s, ReplaceAction.replace(o.toString(), z, this, this.getStateNo(dfa), this.builder.getLabelByState(dfa)));
                }
                out.format("%s\t\t\t__o__->state = %d;\n", s, this.getStateNo(b));
                out.format("%s\t\t\treturn 1;\n", s);
                el2 = false;
            } else {
                b = a.getRecursive();
                if (b != null) {
                    String s = this.outln(els, out);
                    out.format("%s\t\t\t__stk_push_C(__o__, %d, %s);\n", s, this.getStateNo(b), ReplaceStrangeChar.replace(a.getRecursiveName()));
                    out.format("%s\t\t\t__o__->state = 0;\n", s);
                    out.format("%s\t\t\treturn -1;\n", s);
                    el2 = false;
                }
            }
        }
        if (els) {
            out.println("\t\t\t}");
        }
        if (el2) {
            out.println("\t\t\treturn 0;");
        }
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        throw new NinaException("unsupportedobjecttype", "C");
    }

    @Override
    public void printClassStates(PrintStream out) {
        throw new NinaException("unsupportedclasstype", "C");
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        String d = "\treturn (";
        if (this.acceptsSize() == 0) {
            out.println("\treturn 0;");
        } else {
            for (Integer i : this.acceptsIterable()) {
                out.print(d);
                out.format("__o__->state == %d", i);
                d = " ||\n\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        boolean[] z = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isAccepted()) continue;
            String p = null;
            out.format("\tcase %d:\n", this.stateNo(s));
            for (Object a : s.getAccepted()) {
                String x;
                if (a == null || !(a instanceof NinaState) || (x = ((NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.getOptions().pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            p = p != null ? ReplaceAction.replace(p, z, this, this.getStateNo(s), this.builder.getLabelByState(s)) : "return __b__;";
            out.format("\t\t%s\n", p);
        }
    }

    @Override
    public void printActions(PrintStream out) {
        boolean[] a = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            String p = null;
            out.format("\tcase %d:\n", this.stateNo(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\tbreak;");
                continue;
            }
            p = ReplaceAction.replace(p, a, this, this.stateNo(s), this.builder.getLabelByState(s));
            out.format("\t\t%s\n", p);
            if (a[0]) continue;
            out.println("\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
    }

    @Override
    public void printIsEnd(PrintStream out) {
        HashSet<Integer> t = new HashSet<Integer>();
        String d = "\treturn (";
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!(s instanceof DFABuilder.DBS) || ((DFABuilder.DBS)s).getEnd() == null) continue;
            t.add(this.stateNo(s));
        }
        if (t.size() == 0) {
            out.println("\treturn 0;");
        } else {
            for (Integer i : t) {
                out.print(d);
                out.format("__o__->state == %d", i);
                d = " ||\n\t\t\t";
            }
            out.println(");");
        }
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.getDeadStateNo());
    }

    @Override
    protected void printRecover(PrintStream out) {
    }

    @Override
    public void printFinallyState(PrintStream out) {
    }

    @Override
    protected void printAttrs(PrintStream out) {
        boolean b = true;
        for (String x : this.builder.getLabels()) {
            String t;
            if (x == null || x.equals("") || (t = this.builder.getTypeByLabel(x)) == null || t.equals("")) continue;
            b = false;
            out.printf("\t\t%s %s;\n", t, x);
        }
        if (b) {
            out.println("\t\tchar __dummy__;");
        }
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript() {
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".c.sh");
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        String s = this.getOptions().getOption("output");
        s = s.equals("") ? "." : s;
        return new PrintStream(new FileOutputStream(new File(s, String.valueOf(this.getOptions().getOutputFilename()) + ".c")), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorC r = new NinaTranslatorC();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        String l = b1.toString();
        Object o = this.builder.getStateByLabel(l);
        String t = this.builder.getTypeByLabel(l);
        if (l.equals("c")) {
            ot.append("__c__");
        } else if (l.equals("this")) {
            ot.append("(((struct ");
            ot.append(this.options.getFilename());
            ot.append("_tag *)__o__)->__user_fields)");
        } else if (o == null) {
            ot.append('$');
            ot.append(b1);
        } else if (t == null) {
            ot.append('$');
            ot.append(b1);
        } else {
            ot.append("(__stv_C(__o__)).");
            ot.append(this.builder.getName());
            ot.append(".");
            ot.append(b1);
        }
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('@');
            ot.append(b1);
        } else {
            ot.append("(__stv_C(__o__)).");
            ot.append(this.builder.getName());
            ot.append(".");
            ot.append(b1);
        }
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append("(__stv_C(__o__)).");
        ot.append(this.builder.getName());
        ot.append(".");
        ot.append(ln);
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("__b__");
    }
}

