/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.cmd.ZNina;

public class ZNinaOptions
implements NinaConsole {
    private static final String CLSNAME = ZNina.class.getPackage().getName().replace('.', '/');
    private static ResourceBundle msgs;
    Map<String, String> opts = new HashMap<String, String>();
    List<String> libs = new ArrayList<String>();

    public ZNinaOptions() {
        msgs = ResourceBundle.getBundle(String.valueOf(CLSNAME) + "/znina_messages");
    }

    @Override
    public void print(String p, Object ... a) {
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void perror(String p, Object ... a) {
        System.out.print(msgs.getString("errorheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void pwarn(String p, Object ... a) {
        System.out.print(msgs.getString("warnheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void pmessage(String p) {
        System.out.print(msgs.getString("errorheader"));
        System.out.println(p);
    }

    public void usage() {
        int l = Integer.parseInt(msgs.getString("usage.length"));
        this.print("title", "0.3.0.1");
        int i = 1;
        while (i <= l) {
            String x = String.format("%03d", i);
            this.print("usage." + x, new Object[0]);
            ++i;
        }
    }

    public String getOption(String key) {
        String s = this.opts.get(key);
        return s != null ? s : "";
    }

    public int getOptionInt(String key, int def) {
        try {
            String s = this.getOption(key);
            if (s.equals("")) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.perror("notanumber", key);
            System.exit(2);
            return -1;
        }
    }

    public List<String> getLibraryList() {
        return Collections.unmodifiableList(this.libs);
    }
}

