/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.NinaNullConsole;
import net.morilib.nina.cmd.Ninat;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ProxyNinaTranslator;

public class NinatOptions
implements NinaConsole {
    private static final String CLSNAME = Ninat.class.getPackage().getName().replace('.', '/');
    private static ResourceBundle msgs;
    private NinaTranslator translator = new ProxyNinaTranslator();
    Map<String, String> opts = new HashMap<String, String>();
    List<String> libs = new ArrayList<String>();
    NinaConsole console = NinaNullConsole.NULL;
    boolean jflag = false;
    String filename;

    public NinatOptions() {
        msgs = ResourceBundle.getBundle(String.valueOf(CLSNAME) + "/ninat_messages");
    }

    @Override
    public void print(String p, Object ... a) {
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void perror(String p, Object ... a) {
        System.out.print(msgs.getString("errorheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void pwarn(String p, Object ... a) {
        System.out.print(msgs.getString("warnheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    @Override
    public void pmessage(String p) {
        System.out.print(msgs.getString("errorheader"));
        System.out.println(p);
    }

    public void usage() {
        int l = Integer.parseInt(msgs.getString("usage.length"));
        this.print("title", "0.3.0.1");
        int i = 1;
        while (i <= l) {
            String x = String.format("%03d", i);
            this.print("usage." + x, new Object[0]);
            ++i;
        }
    }

    public NinaTranslator getTranslator() {
        return this.translator;
    }

    void setTranslator(NinaTranslator translator) {
        this.translator = translator;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getOutputFilename() {
        String s = this.getOption("outfile");
        return s.equals("") ? this.filename : s;
    }

    public String getOption(String key) {
        String s = this.opts.get(key);
        return s != null ? s : "";
    }

    public boolean isOptionDefined(String key) {
        return this.opts.containsKey(key);
    }

    public List<String> getLibraryList() {
        return Collections.unmodifiableList(this.libs);
    }

    public File getJavaFile() {
        char[] a = (String.valueOf(this.getOutputFilename()) + ".java").toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        String s = this.getOption("output");
        s = s.equals("") ? "." : s;
        return new File(s, new String(a));
    }

    public NinaConsole getConsole() {
        return this.console;
    }
}

