/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.IntervalMap;

public class ConcurrentNFA<T, A, B>
implements NFA<T, A, B> {
    private Collection<NFA<T, A, B>> nfas;
    private NFAState initial;

    public ConcurrentNFA(NFAState ini, Collection<NFA<T, A, B>> c) {
        this.nfas = new ArrayList<NFA<T, A, B>>(c);
        this.initial = ini;
    }

    public ConcurrentNFA(NFAState ini) {
        this.nfas = new ArrayList<NFA<T, A, B>>();
        this.initial = ini;
    }

    void add(NFA<T, A, B> t) {
        this.nfas.add(t);
    }

    @Override
    public boolean isState(NFAState o) {
        if (this.initial.equals(o)) {
            return true;
        }
        for (NFA<T, A, B> n : this.nfas) {
            if (!n.isState(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getStates(state, alphabet));
        }
        return r;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getStates(state, rng));
        }
        return r;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getStates(state, bound));
        }
        return r;
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (this.initial.equals(state)) {
            for (NFA<T, A, B> n : this.nfas) {
                r.addAll(n.getInitialStates());
            }
        } else {
            for (NFA<T, A, B> n : this.nfas) {
                r.addAll(n.getStatesEpsilon(state));
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getStatesBound(state, bound));
        }
        return r;
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.initial);
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.initial.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        for (NFA<T, A, B> n : this.nfas) {
            if (!n.isFinal(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFA<T, A, B> n : this.nfas) {
            if (!n.isFinalAny(states)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        final ArrayList<NFAEdges<T>> l = new ArrayList<NFAEdges<T>>();
        if (this.initial.equals(state)) {
            return new NFAEdges<T>(){

                @Override
                public Set<NFAState> goNext(T alphabet) {
                    return Collections.emptySet();
                }

                @Override
                public Set<NFAState> goNext(int alphabet) {
                    return Collections.emptySet();
                }

                @Override
                public Set<NFAState> goNext(char alphabet) {
                    return Collections.emptySet();
                }

                @Override
                public Set<NFAState> goNextEpsilon() {
                    return ConcurrentNFA.this.getStatesEpsilon(ConcurrentNFA.this.initial);
                }

                @Override
                public Set<? extends Range> nextAlphabets() {
                    return Collections.emptySet();
                }

                @Override
                public boolean isNextEpsilon() {
                    return true;
                }
            };
        }
        for (NFA<T, A, B> n : this.nfas) {
            l.add(n.getEdges(state));
        }
        return new NFAEdges<T>(){

            @Override
            public Set<NFAState> goNext(T alphabet) {
                HashSet<NFAState> r = new HashSet<NFAState>();
                for (NFAEdges n : l) {
                    r.addAll(n.goNext(alphabet));
                }
                return r;
            }

            @Override
            public Set<NFAState> goNext(int alphabet) {
                HashSet<NFAState> r = new HashSet<NFAState>();
                for (NFAEdges n : l) {
                    r.addAll(n.goNext(Integer.valueOf(alphabet)));
                }
                return r;
            }

            @Override
            public Set<NFAState> goNext(char alphabet) {
                HashSet<NFAState> r = new HashSet<NFAState>();
                for (NFAEdges n : l) {
                    r.addAll(n.goNext(Character.valueOf(alphabet)));
                }
                return r;
            }

            @Override
            public Set<NFAState> goNextEpsilon() {
                HashSet<NFAState> r = new HashSet<NFAState>();
                for (NFAEdges n : l) {
                    r.addAll(n.goNextEpsilon());
                }
                return r;
            }

            @Override
            public Set<? extends Range> nextAlphabets() {
                HashSet<Range> r = new HashSet<Range>();
                for (NFAEdges n : l) {
                    r.addAll(n.nextAlphabets());
                }
                return r;
            }

            @Override
            public boolean isNextEpsilon() {
                for (NFAEdges n : l) {
                    if (!n.isNextEpsilon()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        IntervalMap m = null;
        m = new IntervalMap();
        for (NFA<T, A, B> n : this.nfas) {
            for (Interval v : n.nextAlphabets(state)) {
                m.put(v, null);
            }
        }
        return m.keySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        IntervalMap m = null;
        m = new IntervalMap();
        for (NFA<T, A, B> n : this.nfas) {
            for (Interval v : n.nextAlphabets(states)) {
                m.put(v, null);
            }
        }
        return m.keySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        HashSet<T> r = new HashSet<T>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.nextDiscreteAlphabets(state));
        }
        return r;
    }

    @Override
    public Iterable<T> nextDiscreteAlphabets(final Set<NFAState> states) {
        return new Iterable<T>(){
            private Iterator<NFAState> i;
            private Iterator<T> j;

            @Override
            public Iterator<T> iterator() {
                this.i = states.iterator();
                this.j = this.i.hasNext() ? ConcurrentNFA.this.nextDiscreteAlphabets(this.i.next()).iterator() : null;
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext() || j.hasNext();
                    }

                    @Override
                    public T next() {
                        while (!j.hasNext()) {
                            if (i.hasNext()) {
                                j = ConcurrentNFA.this.nextDiscreteAlphabets((NFAState)i.next()).iterator();
                                continue;
                            }
                            throw new NoSuchElementException();
                        }
                        return j.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getAcceptedStates());
        }
        return r;
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        HashSet<B> r = new HashSet<B>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getMatchTag(state));
        }
        return r;
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        HashSet<B> r = new HashSet<B>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getMatchTagEnd(state));
        }
        return r;
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        HashSet<A> r = new HashSet<A>();
        for (NFA<T, A, B> n : this.nfas) {
            r.addAll(n.getAccept(state));
        }
        return r;
    }

    @Override
    public boolean isAccepted(NFAState state) {
        for (NFA<T, A, B> n : this.nfas) {
            if (!n.isAccepted(state)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringWriter b = new StringWriter();
        PrintWriter p = new PrintWriter(b);
        for (NFA<T, A, B> n : this.nfas) {
            p.format("%s\n", n);
        }
        return b.toString();
    }
}

