/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.value;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkString
extends AwkValue {
    public static final AwkString EMPTY = new AwkString("");
    private static final Pattern PFL = Pattern.compile("[-+]?([0-9]+(\\.[0-9]+)?|\\.[0-9]+)([eE][-+]?[0-9]+)?");
    private static final Pattern PIT = Pattern.compile("[-+]?[0-9]+");
    private static final Pattern PDC = Pattern.compile("[-+]?([0-9]*\\.[0-9]+)([eE][-+]?[0-9]+)?");
    private static final Pattern PFI = Pattern.compile("([-+]?([0-9]+(\\.[0-9]+)?|\\.[0-9]+)([eE][-+]?[0-9]+)?)([-+]([0-9]+(\\.[0-9]+)?|\\.[0-9]+)([eE][-+]?[0-9]+)?)[ij]");
    private String value;

    private AwkString(String s) {
        this.value = s;
    }

    public static AwkString valueOf(String s) {
        return new AwkString(s);
    }

    @Override
    public double toFloat() {
        Matcher m = PFL.matcher(this.value);
        if (m.lookingAt()) {
            return Double.parseDouble(m.group().replaceFirst("^\\+", ""));
        }
        return 0.0;
    }

    @Override
    public BigInteger toInteger() {
        Matcher m = PIT.matcher(this.value);
        if (m.lookingAt()) {
            return new BigInteger(m.group().replaceFirst("^\\+", ""));
        }
        return BigInteger.ZERO;
    }

    public Number toReal() {
        Matcher m = PIT.matcher(this.value);
        if (m.lookingAt()) {
            return new BigInteger(m.group().replaceFirst("^\\+", ""));
        }
        return this.toFloat();
    }

    @Override
    public double toImaginary() {
        Matcher m = PFI.matcher(this.value);
        if (m.lookingAt()) {
            return Double.parseDouble(m.group(5).replaceFirst("^\\+", ""));
        }
        return 0.0;
    }

    @Override
    public boolean toBoolean(AwkNamespace ns) {
        return !this.value.equals("");
    }

    public AwkValue toNumber() {
        Matcher m = PFL.matcher(this.value);
        if (m.lookingAt()) {
            if (PIT.matcher(m.group()).matches()) {
                return AwkInteger.valueOf(new BigInteger(m.group().replaceFirst("^\\+", "")));
            }
            return AwkFloat.valueOf(Double.parseDouble(m.group().replaceFirst("^\\+", "")));
        }
        return AwkInteger.ZERO;
    }

    public Pattern toRegex() {
        return Pattern.compile(this.value);
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isFloatValue() {
        return PFL.matcher(this.value).lookingAt();
    }

    @Override
    public boolean isIntegerValue() {
        return PIT.matcher(this.value).lookingAt() && !PDC.matcher(this.value).lookingAt();
    }

    @Override
    public boolean isRealValue() {
        return this.isFloatValue() || this.isIntegerValue();
    }

    public int signum() {
        Matcher m = PIT.matcher(this.value);
        if (m.lookingAt()) {
            return new BigInteger(m.group().replaceFirst("^\\+", "")).signum();
        }
        return (int)Math.signum(this.toFloat());
    }

    @Override
    public boolean isNegativeValue() {
        return this.signum() < 0;
    }

    @Override
    public boolean isPositiveValue() {
        return this.signum() > 0;
    }

    @Override
    public boolean isZeroValue() {
        return this.signum() == 0;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isRegex() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.value.equals("");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AwkString) {
            return this.value.equals(((AwkString)o).value);
        }
        return false;
    }

    @Override
    public String toString(AwkNamespace ns) {
        return this.value;
    }

    @Override
    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        if (ns.isIgnoreCase()) {
            return this.toString(ns).compareToIgnoreCase(o.toString(ns));
        }
        return this.toString(ns).compareTo(o.toString(ns));
    }
}

