/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.regular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.regular.BasicRegex;
import net.morilib.automata.regular.BasicRegexUtils;
import net.morilib.automata.regular.StarClosureBasicRegex;

public class AlternativeBasicRegex
implements BasicRegex {
    Set<BasicRegex> exprs;

    public AlternativeBasicRegex(BasicRegex ... exprs) {
        this(Arrays.asList(exprs));
    }

    public AlternativeBasicRegex(Collection<BasicRegex> exprs) {
        this.exprs = new HashSet<BasicRegex>(exprs);
    }

    @Override
    public BasicRegex simplify() {
        BasicRegex w;
        ArrayList<BasicRegex> l1 = new ArrayList<BasicRegex>();
        int nc = 0;
        for (BasicRegex z : this.exprs) {
            w = z.simplify();
            if (w.equals(BasicRegexUtils.NIHIL)) {
                ++nc;
                continue;
            }
            if (w instanceof AlternativeBasicRegex) {
                l1.addAll(((AlternativeBasicRegex)w).exprs);
                continue;
            }
            l1.add(w);
        }
        if (nc > 0 && nc == this.exprs.size()) {
            return BasicRegexUtils.NIHIL;
        }
        if (l1.size() == 0) {
            return BasicRegexUtils.EPSILON;
        }
        if (l1.size() == 1) {
            return (BasicRegex)l1.get(0);
        }
        HashSet<BasicRegex> s1 = new HashSet<BasicRegex>(l1);
        int i = 0;
        while (i < l1.size()) {
            BasicRegex e = (BasicRegex)l1.get(i);
            int j = i + 1;
            while (j < l1.size()) {
                BasicRegex g;
                BasicRegex f = (BasicRegex)l1.get(j);
                if (f instanceof StarClosureBasicRegex && e instanceof StarClosureBasicRegex) {
                    g = ((StarClosureBasicRegex)e).expr;
                    w = ((StarClosureBasicRegex)f).expr;
                    if (g.equals(w)) {
                        s1.remove(f);
                    }
                } else if (f instanceof StarClosureBasicRegex) {
                    g = ((StarClosureBasicRegex)f).expr;
                    if (e.equals(g)) {
                        s1.remove(e);
                    }
                } else if (e instanceof StarClosureBasicRegex && f.equals(g = ((StarClosureBasicRegex)e).expr)) {
                    s1.remove(f);
                }
                ++j;
            }
            ++i;
        }
        if (s1.size() == 0) {
            return BasicRegexUtils.EPSILON;
        }
        if (s1.size() == 1) {
            return (BasicRegex)s1.iterator().next();
        }
        return new AlternativeBasicRegex(s1);
    }

    public int hashCode() {
        int r = 1547;
        for (BasicRegex e : this.exprs) {
            r = r * 37 + e.hashCode();
        }
        return r;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AlternativeBasicRegex)) {
            return false;
        }
        return this.exprs.equals(((AlternativeBasicRegex)o).exprs);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = "";
        b.append("(");
        for (BasicRegex e : this.exprs) {
            b.append(d).append(e.toString());
            d = "|";
        }
        return b.append(")").toString();
    }
}

