/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import net.morilib.nina.Nina;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.NinaTranslatorJava;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class NinatOptions {

	private static final String CLSNAME =
			Ninat.class.getPackage().getName().replace('.', '/');

	private NinaTranslator translator = new NinaTranslatorJava();
	private Map<String, String> opts = new HashMap<String, String>();
	private String filename;
	private static ResourceBundle msgs;

	/**
	 * 
	 */
	public NinatOptions() {
		msgs = ResourceBundle.getBundle(CLSNAME + "/ninat_messages");
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void print(String p, Object... a) {
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void perror(String p, Object... a) {
		System.out.print(msgs.getString("errorheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void pwarn(String p, Object... a) {
		System.out.print(msgs.getString("warnheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 */
	public void usage() {
		int l = Integer.parseInt(msgs.getString("usage.length"));
		String x;

		print("title", Nina.VERSION);
		for(int i = 1; i <= l; i++) {
			x = String.format("%03d", i);
			print("usage." + x);
		}
	}

	/**
	 * @return the translator
	 */
	public NinaTranslator getTranslator() {
		return translator;
	}

	//
	void setTranslator(NinaTranslator translator) {
		this.translator = translator;
	}

	/**
	 * @return the filename
	 */
	public String getFilename() {
		return filename;
	}

	//
	void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getOption(String key) {
		String s;

		return (s = opts.get(key)) != null ? s : "";
	}

	//
	void setOption(String key, String value) {
		opts.put(key, value);
	}

}
