/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.nina.NinaMap;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class NinaSingleNFA
implements NFA<Object, NFAState, Void>,
NFAEdges<Object> {
    NFAState initial;
    NinaMap<Object, Set<NFAState>> map;

    NinaSingleNFA(NFAState init) {
        this.initial = init;
        this.map = new NinaMap();
    }

    @Override
    public boolean isState(NFAState o) {
        return this.initial.equals(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Object alphabet) {
        Set<NFAState> s;
        if (!this.initial.equals(state) || (s = this.map.get(alphabet)) == null) {
            return Collections.emptySet();
        }
        return new HashSet<NFAState>(s);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        Set<NFAState> s;
        if (!this.initial.equals(state) || (s = this.map.get(rng)) == null) {
            return Collections.emptySet();
        }
        return new HashSet<NFAState>(s);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        if (!this.initial.equals(state)) {
            return Collections.emptySet();
        }
        Set<NFAState> s = this.map.get(null);
        if (s == null) {
            return Collections.emptySet();
        }
        return new HashSet<NFAState>(s);
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.initial);
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.initial.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.getAcceptedStates().contains(state);
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        HashSet<NFAState> t = new HashSet<NFAState>(states);
        t.retainAll(this.getAcceptedStates());
        return !t.isEmpty();
    }

    @Override
    public NFAEdges<Object> getEdges(NFAState state) {
        return this;
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        if (this.initial.equals(state)) {
            return this.map.getKeyRange().intervals();
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        if (states.contains(this.initial)) {
            return this.map.getKeyRange().intervals();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> nextDiscreteAlphabets(NFAState state) {
        if (this.initial.equals(state)) {
            return this.map.getDiscreteKeys();
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<Object> nextDiscreteAlphabets(Set<NFAState> states) {
        if (states.contains(this.initial)) {
            return this.map.getDiscreteKeys();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (Set<NFAState> s : this.map.valueSet()) {
            r.addAll(s);
        }
        return r;
    }

    @Override
    public Set<Void> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<Void> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getAccept(NFAState state) {
        if (this.isAccepted(state)) {
            return Collections.singleton(state);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState state) {
        return this.getAcceptedStates().contains(state);
    }

    @Override
    public Set<NFAState> goNext(Object alphabet) {
        return this.map.get(alphabet);
    }

    @Override
    public Set<NFAState> goNext(int alphabet) {
        return this.map.get(alphabet);
    }

    @Override
    public Set<NFAState> goNext(char alphabet) {
        return this.map.get(Character.valueOf(alphabet));
    }

    @Override
    public Set<NFAState> goNextEpsilon() {
        return this.map.get(Range.O);
    }

    @Override
    public Set<? extends Range> nextAlphabets() {
        return this.map.getKeyRange().intervals();
    }

    @Override
    public boolean isNextEpsilon() {
        return this.map.get(Range.O) != null;
    }

    public String toString() {
        return this.map.toString();
    }
}

