/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.Quadro;
import net.morilib.nina.QuadroImpl;
import net.morilib.range.CharSets;

public class NinaParser {
    static final int _PAUSE = 1;
    static final int _PRINT = 2;
    private Quadro q;
    private S etat = S.INIT;
    private StringBuffer buf = new StringBuffer();
    private StringBuffer bf2 = new StringBuffer();
    private NinaAction action;
    private Class<?> type = Character.TYPE;
    private int pause;
    private Map<String, String> pragmas = new HashMap<String, String>();

    NinaParser(Quadro q, NinaAction action) {
        this.q = q;
        this.action = action;
    }

    Object _compileRes(String n, NinaAction action) {
        try {
            return NinaParser.compile(QuadroImpl.readResource(n), action, this.pause);
        }
        catch (IOException e) {
            throw new NinaParseException(e);
        }
    }

    static Object compile(Quadro q, NinaAction action, int p) {
        Object o;
        NinaParser c = new NinaParser(q, action);
        while ((o = c.step()) == null) {
            if ((p & 2) == 0) continue;
            try {
                if ((p & 1) != 0 && System.in.read() == 13) {
                    System.in.read();
                }
                c.printTrace(System.out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return o;
    }

    private void metBord(char c) {
        char[] a = new char[1];
        if (this.type.equals(Character.TYPE)) {
            this.action.setEdge(this.q, c);
        } else if (this.type.equals(String.class)) {
            a[0] = c;
            this.action.setEdge(this.q, new String(a));
        } else {
            throw new ClassCastException();
        }
    }

    private void metBord(String s) {
        if (this.type.equals(Character.TYPE)) {
            if (s.length() != 1) {
                throw new ClassCastException();
            }
            this.action.setEdge(this.q, s.charAt(0));
        } else if (this.type.equals(String.class)) {
            this.action.setEdge(this.q, s);
        } else if (this.type.isInstance(Integer.class) || this.type.equals(Integer.TYPE)) {
            this.action.setEdge(this.q, Integer.valueOf(s));
        } else if (this.type.isInstance(Long.class) || this.type.equals(Long.TYPE)) {
            this.action.setEdge(this.q, Long.valueOf(s));
        } else if (this.type.isInstance(Float.class) || this.type.equals(Float.TYPE)) {
            this.action.setEdge(this.q, Double.valueOf(s));
        } else if (this.type.isInstance(Double.class) || this.type.equals(Double.TYPE)) {
            this.action.setEdge(this.q, Double.valueOf(s));
        } else if (this.type.isInstance(BigInteger.class)) {
            this.action.setEdge(this.q, new BigInteger(s));
        } else if (this.type.isInstance(BigDecimal.class)) {
            this.action.setEdge(this.q, new BigDecimal(s));
        } else {
            throw new ClassCastException();
        }
    }

    private void metBordRes(String s) {
        this.action.setEdgeResource(this.q, this, s);
    }

    private void metBordCharset(String s) {
        if (!this.type.equals(Character.TYPE)) {
            throw new ClassCastException();
        }
        this.action.setEdge(this.q, CharSets.parse(s));
    }

    Object step() {
        switch (this.etat) {
            case INIT: {
                if (this.q.get() == 35) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PRAG;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                if (this.q.isBlankX()) break;
                this.etat = S.LINIT;
                break;
            }
            case PRAG: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter()) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (!Character.isWhitespace(this.q.get())) {
                    this.q.east();
                    this.etat = S.COMNT;
                    break;
                }
                if (this.buf.toString().equals("package")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PACK;
                    break;
                }
                if (this.buf.toString().equals("machine")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.MACHN;
                    break;
                }
                if (this.buf.toString().equals("type")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.TYPE;
                    break;
                }
                if (!this.buf.toString().equals("option")) break;
                this.buf = new StringBuffer();
                this.q.east();
                this.etat = S.OPTN;
                break;
            }
            case PACK: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.q.setRootPackage(s);
                this.q.setRootResource("/" + s.replace('.', '/'));
                this.pragmas.put("package", s);
                this.etat = S.COMNT;
                break;
            }
            case MACHN: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.pragmas.put("machine", s);
                if (s.indexOf(46) < 0) {
                    s = String.valueOf(this.getClass().getPackage().getName()) + "." + s;
                }
                NinaAction n = (NinaAction)Nina.prendClasse(s);
                if (this.action == null) {
                    this.action = n;
                } else if (!this.action.getClass().equals(n.getClass())) {
                    throw new NinaParseException(this);
                }
                this.etat = S.COMNT;
                break;
            }
            case TYPE: {
                String s = null;
                if (this.q.get() == -1) {
                    this.q.east();
                } else if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                } else {
                    s = this.buf.toString().trim();
                    if (s.equals("char")) {
                        this.type = Character.TYPE;
                        this.etat = S.COMNT;
                    } else {
                        s = this.buf.toString().trim();
                        if (s.equals("int")) {
                            this.type = Integer.TYPE;
                            this.etat = S.COMNT;
                        } else {
                            s = this.buf.toString().trim();
                            if (s.equals("long")) {
                                this.type = Long.TYPE;
                                this.etat = S.COMNT;
                            } else {
                                s = this.buf.toString().trim();
                                if (s.equals("float")) {
                                    this.type = Float.TYPE;
                                    this.etat = S.COMNT;
                                } else {
                                    s = this.buf.toString().trim();
                                    if (s.equals("double")) {
                                        this.type = Double.TYPE;
                                        this.etat = S.COMNT;
                                    } else {
                                        s = this.buf.toString().trim();
                                        if (s.equals("string")) {
                                            this.type = String.class;
                                            this.etat = S.COMNT;
                                        } else {
                                            this.type = (Class)Nina.prendClasse(s);
                                            this.etat = S.COMNT;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (s == null) break;
                this.pragmas.put("type", s);
                break;
            }
            case OPTN: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter()) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() == 61) {
                    this.bf2 = new StringBuffer();
                    this.q.east();
                    this.etat = S.OPTV;
                    break;
                }
                this.q.options.put(this.buf.toString(), "");
                this.etat = S.COMNT;
                break;
            }
            case OPTV: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter()) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), this.bf2.toString());
                this.etat = S.COMNT;
                break;
            }
            case COMNT: {
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                this.q.east();
                break;
            }
            case LINIT: {
                if (this.q.get() == 61 || this.q.get() == 38) {
                    this.etat = S.LBLE;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                this.q.east();
                break;
            }
            case LBLE: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    int c = this.q.get();
                    this.q.south().east();
                    NinaFrameReader rd = new NinaFrameReader(this.q);
                    this.action.labelAdded(this.q, rd, c == 64 || c == 38);
                    rd.close();
                    this.etat = S.FMNW;
                    break;
                }
                this.q.west();
                break;
            }
            case FMNW: {
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FMNW2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FMNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_E;
                } else {
                    throw new NinaParseException(this);
                }
            }
            case FM_E: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FMNE;
                break;
            }
            case FMNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FMNE2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FMNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_S;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FM_S: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FMSE;
                break;
            }
            case FMSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FMSE2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FMSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_W;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FM_W: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FMSW;
                break;
            }
            case FMSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FMSW2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FMSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_N;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FM_N: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRNW;
                    break;
                }
                this.q.south();
                this.etat = S.FRNW;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case FRNW: {
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FRNW2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FRNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_E;
                } else {
                    throw new NinaParseException(this);
                }
            }
            case FR_E: {
                if (this.q.get() == 94) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FRNE;
                break;
            }
            case FRNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FRNE2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FRNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_S;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FR_S: {
                if (this.q.get() == 62) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FRSE;
                break;
            }
            case FRSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FRSE2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FRSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_W;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FR_W: {
                if (this.q.get() == 118) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FRSW;
                break;
            }
            case FRSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FRSW2;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FRSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_N;
                    break;
                }
                throw new NinaParseException(this);
            }
            case FR_N: {
                if (this.q.get() == 60) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.FRR_S;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case AR_N: {
                if (this.q.get() == 47) {
                    this.q.set(-103);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-103);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(this.q.getEdge());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 94) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.south();
                        this.etat = S.ARR_S;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_W;
                    break;
                }
                if (this.q.isLetter()) {
                    this.q.setEdge(Character.valueOf((char)this.q.get()));
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.AR_ZE;
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_ZE: {
                this.q.set(94);
                this.q.east();
                this.etat = S.FR_E;
                break;
            }
            case AR_E: {
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(this.q.getEdge());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 62) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.west();
                        this.etat = S.ARR_W;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EQ;
                    break;
                }
                if (this.q.get() == 123) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_ER;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EI;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E1;
                    break;
                }
                if (this.q.isLetter()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.AR_ZS;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_ZS: {
                this.q.set(62);
                this.q.south();
                this.etat = S.FR_S;
                break;
            }
            case AR_EQ: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 39) {
                    this.metBord(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_ER: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 125) {
                    this.metBordRes(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_EI: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 93) {
                    this.metBordCharset(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case WP_E1: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.etat = S.TOIX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_S: {
                if (this.q.get() == 47) {
                    this.q.set(-102);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-102);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(this.q.getEdge());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 118) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.north();
                        this.etat = S.ARR_N;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_W;
                    break;
                }
                if (this.q.isLetter()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.AR_ZW;
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_ZW: {
                this.q.set(118);
                this.q.west();
                this.etat = S.FR_W;
                break;
            }
            case AR_W: {
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(this.q.getEdge());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 60) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.east();
                        this.etat = S.ARR_E;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.buf = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 125) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WR;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W1;
                    break;
                }
                if (this.q.isLetter()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.AR_ZN;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_ZN: {
                this.q.set(60);
                this.q.north();
                this.etat = S.FR_N;
                break;
            }
            case AR_WQ: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 39) {
                    this.metBord(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_WR: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 123) {
                    this.metBordRes(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case AR_WI: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this);
                }
                if (this.q.get() == 91) {
                    this.metBordCharset(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case WP_W1: {
                if (this.q.get() == 40) {
                    this.buf.reverse();
                    this.q.set(-400);
                    this.etat = S.TOIX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case F2_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.F2_N;
                break;
            }
            case F2_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.LBLE;
                break;
            }
            case F3_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                this.q.east();
                this.etat = S.LBLE;
                break;
            }
            case F3_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                this.q.south();
                this.etat = S.F3_W;
                break;
            }
            case FRR_S: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.south();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                this.q.north().east();
                this.etat = S.FRR_E;
                break;
            }
            case FRR_E: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.east();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.FRR_N;
                break;
            }
            case FRR_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.north();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.south().west();
                this.etat = S.FRR_W;
                break;
            }
            case FRR_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.west();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                return this.action.accept();
            }
            case ARR_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(this.q.getScratch());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.west();
                    this.etat = S.FR_W;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.ARRZW;
                    break;
                }
                throw new NinaParseException(this);
            }
            case ARRZW: {
                this.q.set(-300);
                this.etat = S.FRR_W;
                break;
            }
            case ARR_E: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E2;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(this.q.getScratch());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.north();
                    this.etat = S.FR_N;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.ARRZN;
                    break;
                }
                throw new NinaParseException(this);
            }
            case WP_E2: {
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case ARRZN: {
                this.q.set(-300);
                this.etat = S.FRR_N;
                break;
            }
            case ARR_S: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(this.q.getScratch());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.east();
                    this.etat = S.FR_E;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.ARRZE;
                    break;
                }
                throw new NinaParseException(this);
            }
            case ARRZE: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case ARR_W: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W2;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(this.q.getScratch());
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.south();
                    this.etat = S.FR_S;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.ARRZS;
                    break;
                }
                throw new NinaParseException(this);
            }
            case WP_W2: {
                if (this.q.get() == -400) {
                    this.buf.reverse();
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case ARRZS: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case BR_N: {
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                this.q.south().east();
                this.etat = S.BR_E;
                break;
            }
            case BR_E: {
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                this.q.west().south();
                this.etat = S.BR_S;
                break;
            }
            case BR_S: {
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.BR_W;
                break;
            }
            case BR_W: {
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                this.q.east().north();
                this.etat = S.BR2_N;
                break;
            }
            case BR2_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                this.q.south().east();
                this.etat = S.BR2_E;
                break;
            }
            case BR2_E: {
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.west().south();
                this.etat = S.BR2_S;
                break;
            }
            case BR2_S: {
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.BR2_W;
                break;
            }
            case BR2_W: {
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaParseException(this);
            }
            case TOIX1: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY1;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY1: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER1E: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1F: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.west();
                        this.etat = S.SER1G;
                        break;
                    }
                    this.etat = S.SER1E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER1G: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.SER1H;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER1H: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER1W: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != 45) {
                    this.q.east();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1X: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.set(-400);
                        this.q.west();
                        this.etat = S.SER1Y;
                        break;
                    }
                    this.etat = S.SER1W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER1Y: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this);
            }
            case TOIX2: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY2;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY2: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER2E: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.east();
                    this.etat = S.SER2W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2F: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.west();
                    this.etat = S.SER2G;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2G: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.SER2H;
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER2H: {
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                throw new NinaParseException(this);
            }
            case SER2W: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this);
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != -101) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2X: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.SER2Y;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2Y: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaParseException(this);
            }
        }
        return null;
    }

    public String getPragma(String s) {
        return this.pragmas.get(s);
    }

    public void printTrace(PrintStream pr) {
        pr.println((Object)this.etat);
        pr.println(this.q.toString());
        pr.println((int)((char)(this.q.get() < 0 ? this.q.get() : (char)this.q.get())));
    }

    private static enum S {
        INIT,
        PRAG,
        PACK,
        MACHN,
        TYPE,
        OPTN,
        OPTV,
        COMNT,
        LINIT,
        FMNW,
        FMNW2,
        FM_E,
        FMNE,
        FMNE2,
        FM_S,
        FMSE,
        FMSE2,
        FM_W,
        FMSW,
        FMSW2,
        FM_N,
        FRNW,
        FRNW2,
        FR_E,
        FRNE,
        FRNE2,
        FR_S,
        FRSE,
        FRSE2,
        FR_W,
        FRSW,
        FRSW2,
        FR_N,
        LBLE,
        AR_N,
        AR_E,
        AR_EQ,
        AR_ER,
        AR_EI,
        AR_S,
        AR_W,
        AR_WQ,
        AR_WR,
        AR_WI,
        AR_ZN,
        AR_ZS,
        AR_ZE,
        AR_ZW,
        F2_W,
        F2_N,
        F3_W,
        F3_N,
        BR_N,
        BR_E,
        BR_S,
        BR_W,
        BR2_N,
        BR2_E,
        BR2_S,
        BR2_W,
        FRR_S,
        FRR_E,
        FRR_N,
        FRR_W,
        ARR_N,
        ARR_E,
        ARR_S,
        ARR_W,
        ARRZN,
        ARRZS,
        ARRZE,
        ARRZW,
        WP_E1,
        WP_W1,
        TOIX1,
        TOIY1,
        SER1E,
        SER1F,
        SER1G,
        SER1H,
        SER1W,
        SER1X,
        SER1Y,
        WP_E2,
        WP_W2,
        TOIX2,
        TOIY2,
        SER2E,
        SER2F,
        SER2G,
        SER2H,
        SER2W,
        SER2X,
        SER2Y;

    }
}

