/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.nina.ConcurrentNFA;
import net.morilib.nina.NinaSingleNFA;
import net.morilib.nina.NinaState;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;

public class NinaNFA
implements NFA<Object, NFAState, Void> {
    private final NFAEdges<Object> deadEdge = new NFAEdges<Object>(){

        @Override
        public Set<NFAState> goNext(Object alphabet) {
            return Collections.emptySet();
        }

        @Override
        public Set<NFAState> goNext(int alphabet) {
            return Collections.emptySet();
        }

        @Override
        public Set<NFAState> goNext(char alphabet) {
            return Collections.emptySet();
        }

        @Override
        public Set<NFAState> goNextEpsilon() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends Range> nextAlphabets() {
            return Collections.emptySet();
        }

        @Override
        public boolean isNextEpsilon() {
            return false;
        }
    };
    NinaState initial;
    Map<NFAState, NFA<Object, NFAState, Void>> edges = new HashMap<NFAState, NFA<Object, NFAState, Void>>();
    Map<NFAState, Void> accept = new HashMap<NFAState, Void>();

    NinaNFA() {
    }

    void linkAlphabet(NFAState b, NFAState e, Object alpha) {
        if (b == null || e == null) {
            return;
        }
        NinaSingleNFA m = this.edges.get(b);
        if (m == null) {
            m = new NinaSingleNFA(b);
            this.edges.put(b, m);
        }
        if (m instanceof NinaSingleNFA) {
            Set<NFAState> s = m.getStates(b, alpha);
            s = s == null ? new HashSet<NFAState>() : new HashSet<NFAState>(s);
            s.add(e);
            m.map.put(alpha, s);
        } else if (m instanceof ConcurrentNFA) {
            ((ConcurrentNFA)((Object)m)).add(m);
        } else {
            throw new ClassCastException();
        }
    }

    void linkAlphabet(NFAState b, NFAState e, Range rng) {
        if (b == null || e == null) {
            return;
        }
        NinaSingleNFA m = this.edges.get(b);
        if (m == null) {
            m = new NinaSingleNFA(b);
            this.edges.put(b, m);
        }
        if (m instanceof NinaSingleNFA) {
            Set<NFAState> s = m.getStates(b, rng);
            s = s == null ? new HashSet<NFAState>() : new HashSet<NFAState>(s);
            s.add(e);
            m.map.put(rng, s);
        } else if (m instanceof ConcurrentNFA) {
            ((ConcurrentNFA)((Object)m)).add(m);
        } else {
            throw new ClassCastException();
        }
    }

    void linkNFA(NFAState b, NFAState e, NFA<Object, NFAState, Void> nfa) {
        ConcurrentNFA p;
        if (b == null || e == null) {
            return;
        }
        NFA<Object, NFAState, Void> m = this.edges.get(b);
        if (m == null) {
            p = new ConcurrentNFA(b, e);
        } else if (m instanceof NinaSingleNFA) {
            p = new ConcurrentNFA(b, e);
            p.add(m);
        } else if (m instanceof ConcurrentNFA) {
            p = (ConcurrentNFA)m;
        } else {
            throw new ClassCastException();
        }
        p.add(nfa);
        this.edges.put(b, p);
    }

    @Override
    public boolean isState(NFAState o) {
        return this.edges.containsKey(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Object alphabet) {
        Set<NFAState> s;
        HashSet<NFAState> p = new HashSet<NFAState>();
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m != null && (s = m.getStates(state, alphabet)) != null) {
            p.addAll(s);
        }
        for (NFAState t : this.edges.keySet()) {
            m = this.edges.get(t);
            p.addAll(m.getStates(state, alphabet));
        }
        return p;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        Set<NFAState> s;
        HashSet<NFAState> p = new HashSet<NFAState>();
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m != null && (s = m.getStates(state, rng)) != null) {
            p.addAll(s);
        }
        for (NFAState t : this.edges.keySet()) {
            m = this.edges.get(t);
            p.addAll(m.getStates(state, rng));
        }
        return p;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        Set<NFAState> s;
        HashSet<NFAState> p = new HashSet<NFAState>();
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m != null && (s = m.getStatesEpsilon(state)) != null) {
            p.addAll(s);
        }
        for (NFAState t : this.edges.keySet()) {
            m = this.edges.get(t);
            p.addAll(m.getStatesEpsilon(state));
        }
        return p;
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.initial);
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.initial.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.accept.containsKey(state);
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.accept.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<Object> getEdges(NFAState state) {
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m == null) {
            return this.deadEdge;
        }
        if (m instanceof NinaSingleNFA) {
            return (NinaSingleNFA)m;
        }
        if (m instanceof ConcurrentNFA) {
            return ((ConcurrentNFA)m).getEdges(state);
        }
        throw new RuntimeException();
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        HashSet<Interval> p = new HashSet<Interval>();
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m != null) {
            p.addAll(m.nextAlphabets(state));
        }
        for (NFAState t : this.edges.keySet()) {
            m = this.edges.get(t);
            p.addAll(m.nextAlphabets(state));
        }
        return p;
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        RangeAdder a = new RangeAdder();
        for (NFAState s : states) {
            for (Interval v : this.nextAlphabets(s)) {
                a.addInterval(v);
            }
        }
        return a.toRange().intervals();
    }

    @Override
    public Set<Object> nextDiscreteAlphabets(NFAState state) {
        HashSet<Object> p = new HashSet<Object>();
        NFA<Object, NFAState, Void> m = this.edges.get(state);
        if (m != null) {
            p.addAll(m.nextDiscreteAlphabets(state));
        }
        for (NFAState t : this.edges.keySet()) {
            m = this.edges.get(t);
            p.addAll(m.nextDiscreteAlphabets(state));
        }
        return p;
    }

    @Override
    public Iterable<Object> nextDiscreteAlphabets(Set<NFAState> states) {
        HashSet<Object> a = new HashSet<Object>();
        for (NFAState s : states) {
            a.addAll(this.nextDiscreteAlphabets(s));
        }
        return a;
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return new HashSet<NFAState>(this.accept.keySet());
    }

    @Override
    public Set<Void> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<Void> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getAccept(NFAState state) {
        return this.accept.containsKey(state) ? Collections.singleton(state) : Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState state) {
        return this.accept.containsKey(state);
    }

    public String toString() {
        StringWriter b = new StringWriter();
        PrintWriter p = new PrintWriter(b);
        p.format("Initial: %s\n", this.initial);
        p.format("accept: %s\n", this.accept.keySet());
        for (NFAState s : this.edges.keySet()) {
            p.format("State %s:\n", s);
            p.format("Edges:\n%s\n\n", this.edges.get(s).toString());
        }
        return b.toString();
    }
}

