/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaState;
import net.morilib.range.Range;

public class NFABuilder
implements NinaAction {
    private NinaNFA nfa = new NinaNFA();
    private NinaState vertex;
    private String label;

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        BufferedReader br = new BufferedReader(rd);
        try {
            this.label = br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.vertex == null) {
            this.nfa.initial = this.vertex = new NinaState();
        }
        if (accept) {
            this.nfa.accept.put(this.vertex, null);
        }
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        NinaState v = this.vertex;
        NinaState ninaState = this.vertex = ver != null ? (NinaState)ver : new NinaState();
        if (q.getEdge() instanceof NFA) {
            this.nfa.linkNFA(v, this.vertex, (NFA)q.getEdge());
        } else if (q.getEdge() instanceof Range) {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, (Range)q.getEdge());
        } else {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, q.getEdge());
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (NinaState)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (NinaState)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s) {
        q.setEdge(p._compileRes(s, new NFABuilder()));
    }

    @Override
    public Object accept() {
        return this.nfa;
    }
}

