/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.morilib.math.stochastic.StochasticProcess;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNondeterministicException;
import net.morilib.nina.NinaParser;
import net.morilib.util.Tuple2;

public class MarkovChainBuilder
implements NinaAction {
    private DBS initial;
    private DBS vertex;
    private String label;

    private DBS prendEtat() {
        DBS s = new DBS();
        return s;
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        BufferedReader br = new BufferedReader(rd);
        try {
            this.label = br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.vertex == null) {
            this.initial = this.vertex = this.prendEtat();
        }
        this.vertex.output = this.label;
        this.vertex.accepted = accept;
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        this.vertex = ver != null ? (DBS)ver : this.prendEtat();
        v.linkAlphabet(this.vertex, Double.valueOf(q.getEdge().toString()));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s) {
        throw new NinaNondeterministicException();
    }

    @Override
    public StochasticProcess accept() {
        return this.initial;
    }

    static class DBS
    implements StochasticProcess {
        List<Tuple2<Number, DBS>> edges = new ArrayList<Tuple2<Number, DBS>>();
        boolean accepted;
        Object output;
        double sum;

        DBS() {
        }

        void linkAlphabet(DBS d, Number o) {
            this.edges.add(new Tuple2<Number, DBS>(o, d));
            this.sum += o.doubleValue();
        }

        @Override
        public DBS go(double r) {
            double l = 0.0;
            DBS x = null;
            for (Tuple2<Number, DBS> e : this.edges) {
                double v = e.getA().doubleValue() / this.sum;
                x = e.getB();
                if (r > l && r <= l + v) {
                    return x;
                }
                l += v;
            }
            return x;
        }

        @Override
        public boolean isDead() {
            return this.edges.isEmpty();
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public Object getOutput() {
            return this.output;
        }
    }
}

