/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNondeterministicException;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.NinaParser;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.TreeSectionMap;

public class DFABuilder
implements NinaAction {
    private DBS initial;
    private DBS vertex;
    private String label;

    private DBS prendEtat() {
        DBS s = new DBS();
        return s;
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        BufferedReader br = new BufferedReader(rd);
        try {
            this.label = br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.vertex == null) {
            this.vertex = this.prendEtat();
            this.vertex.initial = true;
            this.initial = this.vertex;
        }
        this.vertex.accepted = accept;
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        DBS dBS = this.vertex = ver != null ? (DBS)ver : this.prendEtat();
        if (q.getEdge() instanceof Range) {
            v.linkAlphabet(this.vertex, (Range)q.getEdge());
        } else {
            v.linkAlphabet(this.vertex, q.getEdge());
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s) {
        throw new NinaNondeterministicException();
    }

    @Override
    public Object accept() {
        return new DFA<Object, Object, Void>(){

            @Override
            public DFAState<Object, Object, Void> getInitialState() {
                return DFABuilder.this.initial;
            }
        };
    }

    static class DBS
    implements DFAState<Object, Object, Void> {
        TreeSectionMap<Interval, Object, DBS> edges;
        boolean initial;
        boolean accepted;

        DBS() {
        }

        void linkAlphabet(DBS d, Object o) {
            if (this.edges == null) {
                this.edges = new TreeSectionMap(Interval.newPoint(o), d);
            } else if (this.edges.map(o) == null) {
                this.edges.insert(Interval.newPoint(o), d);
            } else {
                throw new NinaNondeterministicException();
            }
        }

        void linkAlphabet(DBS d, Range o) {
            for (Interval v : o.intervals()) {
                if (this.edges == null) {
                    this.edges = new TreeSectionMap(v, d);
                    continue;
                }
                for (Interval w : this.edges.keys()) {
                    if (o.independentOf(w)) continue;
                    throw new NinaNondeterministicException();
                }
                this.edges.insert(v, d);
            }
        }

        @Override
        public DFAState<Object, Object, Void> go(Object a) {
            DBS d = this.edges != null ? this.edges.map(a) : null;
            return d != null ? d : DFAs.deadState();
        }

        @Override
        public DFAState<Object, Object, Void> goInt(int x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goChar(char x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goBound(TextBound b) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.initial;
        }

        @Override
        public Set<Object> getAccepted() {
            return this.accepted ? Collections.singleton(this) : Collections.emptySet();
        }

        @Override
        public boolean isDead() {
            return this.edges == null;
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public Set<Object> getAlphabets() {
            HashSet<Object> r = new HashSet<Object>();
            for (Interval v : this.edges.keys()) {
                Object b;
                Object a = v.getInfimumBound();
                if (a.equals(b = v.getSupremumBound())) {
                    r.add(a);
                    continue;
                }
                if (a instanceof Integer) {
                    int x;
                    int i = x = ((Integer)a).intValue();
                    while (v.contains(i)) {
                        r.add(i);
                        ++i;
                    }
                    continue;
                }
                throw new NinaParseException();
            }
            return r;
        }
    }
}

