#include "ISO9660.h"
#include "VirtualCD.h"

#include <stdio.h>
#include <string.h>

using namespace MonAPI;

bool read(ISO9660* iso, const char* filePath)
{
    File* file = iso->GetFile(filePath);

    if (file == NULL)
    {
        printf("read:file not found\n");
        return false;
    }

    char* buffer = new char[file->GetSize()];
    file->Seek(0, SEEK_SET);
    file->Read(buffer, file->GetSize());

    for (dword i = 0; i < file->GetSize(); i++)
    {
        printf("%c", buffer[i]);
    }

    delete [] buffer;
    delete file;

    return true;
}

bool cp(ISO9660* iso, const char* filePath, const char* outPath)
{
    File* file = iso->GetFile(filePath);

    if (file == NULL)
    {
        printf("cp:file not found\n");
        return false;
    }

    char* buffer = new char[file->GetSize()];
    file->Seek(0, SEEK_SET);
    file->Read(buffer, file->GetSize());

    FILE* out = fopen(outPath, "wb");
    if (out == NULL)
    {
        delete [] buffer;
        return false;
    }

    fwrite(buffer, sizeof(byte), file->GetSize(), out);
    fclose(out);
    delete [] buffer;
    return true;
}


int main(int argc, char *argv[])
{
    if (argc < 4)
    {
        printf("usage: ISO9660.exe comand isoImage filePath [outPath for cp]\n");
        printf("command: read, ls, cp\n");
        return 1;
    }

    const char* command  = argv[1];
    const char* isoImage = argv[2];
    const char* filePath = argv[3];
    const char* outFile  = argv[4];

    FILE* fp = fopen(isoImage, "rb");

    if (fp == NULL)
    {
        printf("file %s can not read\n", isoImage);
        return 1;
    }

    IStorageDevice* cd = new VirtualCD(fp);
    ISO9660* iso = new ISO9660(cd, "");

    if (!iso->Initialize())
    {
        printf("Initialize Error = %d\n", iso->GetLastError());
        delete iso;
        delete cd;
        fclose(fp);
        return 1;
    }

    if (strcmp(command, "read") == 0)
    {
        read(iso, filePath);
    }
    else if (strcmp(command, "cp") == 0)
    {
        cp(iso, filePath, outFile);
    }
    else if (strcmp(command, "ls") == 0)
    {
        _A<CString> files = iso->GetFileSystemEntries(filePath);

        FOREACH (CString, file, files)
        {
            printf("%s\n", (const char*)file);
        }
        END_FOREACH
    }
    else
    {
        printf("command %s not supported\n", command);
    }

    delete iso;
    delete cd;
    fclose(fp);

    return 0;
}
