// COM_XMultiLanguage.cpp cCve[Vt@C
// COM IMultiLanguage2 gpĂ̂ŁAInternet Explorer 5.0ȏオKv
#include "COM_XMultiLanguage.h"
#include "../wgfunc.h"                  // wgc::wgfThrowLastError()
#include <assert.h>                     // assert()


_WXC_BEGIN                              // namespace wxc {

COM_XMultiLanguage2::COM_XMultiLanguage2(void) : m_pMultiLanguage2(NULL)
{
	IMultiLanguage2 *pMultiLanguage2 = NULL;
	HRESULT hResult = ::CoCreateInstance(
		CLSID_CMultiLanguage,
		NULL,
		CLSCTX_ALL,
		IID_IMultiLanguage2,
		reinterpret_cast<LPVOID *>(&pMultiLanguage2));
	if(hResult != S_OK)
	{
		wgc::wgfThrowLastError();
	}
	m_pMultiLanguage2 = pMultiLanguage2;
}

COM_XMultiLanguage2::~COM_XMultiLanguage2(void)
{
	m_pMultiLanguage2->Release();
	m_pMultiLanguage2 = NULL;
}


// R[h̎o
HRESULT COM_XMultiLanguage2::AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize, DetectEncodingInfo arEncoding[], INT &rnScores, const MLDETECTCP nDetectFlag /* = MLDETECTCP_NONE */, const DWORD dwPrefWinCodePage /* = 0 */)
{
	assert(arEncoding != NULL);

	// o
	INT nSize_Copy = static_cast<INT>(cSrcSize);
	return m_pMultiLanguage2->DetectInputCodepage(
		nDetectFlag, dwPrefWinCodePage,
		const_cast<CHAR *>(pSrcStr), &nSize_Copy,
		arEncoding, &rnScores);
}

// R[h̎o
UINT COM_XMultiLanguage2::AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize, const MLDETECTCP nDetectFlag /* = MLDETECTCP_NONE */, const DWORD dwPrefWinCodePage /* = 0 */)
{
	// o
	DetectEncodingInfo info;
	INT nScores = 1;

	const HRESULT hResult = AutoDetect(
		pSrcStr, cSrcSize,
		&info, nScores,
		nDetectFlag, dwPrefWinCodePage);

	if(hResult != S_OK)
	{
		return CODEPAGE_ERROR;
	}
	return info.nCodePage;
}


// R[hy[W uCodePage Ŏ镶 pSrcStr jR[hɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertToUnicodeSize(LPCSTR pSrcStr, const SIZE_T cSrcSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<INT>(cSrcSize);
	UINT cDstSize_Copy = 0;
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringToUnicode(
		&dwMode, uCodePage,
		const_cast<CHAR *>(pSrcStr), &cSrcSize_Copy,
		NULL, &cDstSize_Copy);
	if(hResult != S_OK)
	{
		wgc::wgfThrowLastError();
	}
	return cDstSize_Copy;
}

// R[hy[W uCodePage Ŏ镶 pSrcStr jR[hɕϊ
DWORD COM_XMultiLanguage2::ConvertToUnicode(LPCSTR pSrcStr, const SIZE_T cSrcSize, LPWSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize_Copy = static_cast<UINT>(cDstSize);
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringToUnicode(
		&dwMode, uCodePage,
		const_cast<CHAR *>(pSrcStr), &cSrcSize_Copy,
		pDstStr, &cDstSize_Copy);

	if(hResult != S_OK)
	{
		wgc::wgfThrowLastError();
	}
	return cDstSize_Copy;
}

// R[hy[W uCodePage Ŏ镶 rSrcStr jR[hɕϊ
DWORD COM_XMultiLanguage2::ConvertToUnicode(const wgc::string_t &rSrcStr, wgc::wstring_t &rDstStr, const UINT uCodePage)
{
	const DWORD dwSize = ConvertToUnicodeSize(rSrcStr.c_str(), rSrcStr.size(), uCodePage);

	rDstStr.resize(dwSize);
	return ConvertToUnicode(
		rSrcStr.c_str(), rSrcStr.size(),
		&rDstStr[0]    , rDstStr.size(),
		uCodePage);
}


// jR[h pSrcStr R[hy[W uCodePage ɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertFromUnicodeSize(LPCWSTR pSrcStr, const SIZE_T cSrcSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize_Copy = 0;
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringFromUnicode(
		&dwMode, uCodePage,
		const_cast<WCHAR *>(pSrcStr), &cSrcSize_Copy,
		NULL, &cDstSize_Copy);
	if(hResult != S_OK)
	{
		wgc::wgfThrowLastError();
	}
	return cDstSize_Copy;
}

// jR[h pSrcStr R[hy[W uCodePage ɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertFromUnicode(LPCWSTR pSrcStr, const SIZE_T cSrcSize, LPSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize_Copy = static_cast<UINT>(cDstSize);
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringFromUnicode(
		&dwMode, uCodePage,
		const_cast<WCHAR *>(pSrcStr), &cSrcSize_Copy,
		pDstStr, &cDstSize_Copy);

	if(hResult != S_OK)
	{
		wgc::wgfThrowLastError();
	}
	return cDstSize_Copy;
}

// jR[h pSrcStr R[hy[W uCodePage ɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertFromUnicode(const wgc::wstring_t &rSrcStr, wgc::string_t &rDstStr, const UINT uCodePage)
{
	const DWORD dwSize = ConvertFromUnicodeSize(rSrcStr.c_str(), rSrcStr.size(), uCodePage);

	rDstStr.resize(dwSize);
	return ConvertFromUnicode(
		rSrcStr.c_str(), rSrcStr.size(),
		&rDstStr[0]    , rDstStr.size(),
		uCodePage);
}

_WXC_END                                // }
