// TreeCtrl.cpp cCve[Vt@C
#include "TreeCtrl.h"


_WGC_BEGIN                              // namespace wgc {

// RXgN^
TreeCtrl::TreeCtrl(void)
{
}

// fXgN^
TreeCtrl::~TreeCtrl(void)
{
}


// 
HTREEITEM TreeCtrl::InsertItem(TVINSERTSTRUCT &rInsertStruct)
{
	const LRESULT lResult = SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&rInsertStruct));
	return reinterpret_cast<HTREEITEM>(lResult);
}

BOOL TreeCtrl::Expand(HTREEITEM hItem, const UINT nCode)
{
	const LRESULT lResult = SendMessage(TVM_EXPAND, nCode, reinterpret_cast<LPARAM>(hItem));
	return static_cast<BOOL>(lResult);
}

BOOL TreeCtrl::SelectItem(HTREEITEM hItem, const DWORD dwFlag /* = TVGN_CARET */)
{
	const LRESULT lResult = SendMessage(TVM_SELECTITEM, dwFlag, reinterpret_cast<LPARAM>(hItem));
	return static_cast<BOOL>(lResult);
}


// 
BOOL TreeCtrl::GetItem(TVITEM &rItem) const
{
	const LRESULT lResult = SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&rItem));
	return static_cast<BOOL>(lResult);
}

BOOL TreeCtrl::SetItem(const TVITEM &rItem)
{
	const LRESULT lResult = SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&rItem));
	return static_cast<BOOL>(lResult);
}


// 
DWORD_PTR TreeCtrl::GetItemData(HTREEITEM hItem) const
{
	TVITEM item = {TVIF_HANDLE | TVIF_PARAM};
	item.hItem = hItem;

	GetItem(item);
	return item.lParam;
}

BOOL TreeCtrl::SetItemData(HTREEITEM hItem, const DWORD dwData)
{
	TVITEM item = {TVIF_HANDLE | TVIF_PARAM};
	item.hItem  = hItem;
	item.lParam = dwData;

	return SetItem(item);
}

_WGC_END                                // }
