// Thread.h c Xbh֘ÃNX
#ifndef __THREAD__
#define __THREAD__

#include "wgc.h"


// CRTgȂꍇ͈ȉ̃}N
#define _CRT

_WGC_BEGIN

// XbhNX
class ThreadBase
{
public:
	// RXgN^/fXgN^
	ThreadBase(void);
	virtual ~ThreadBase(void);

	void Run(LPVOID lpParameter = NULL, const DWORD dwCreationFlags = 0);

	// f/ĊJ
	DWORD Suspend(void);
	DWORD Resume (void);

	// ҋ@
	DWORD Wait(const DWORD dwMilliseconds = INFINITE);

protected:
	// Xbh̃C֐
	virtual DWORD ThreadMain(LPVOID lpParameter) = 0;

	// I
	VOID Exit(const DWORD dwExitCode = 0);

private:
	// Xbh
	HANDLE m_hThread;                      // Xbhnh
	LPVOID m_lpParameter;                  // Xbhɓnp[^

#ifdef _CRT
	// C^Cgꍇ
	static HANDLE Create(unsigned int (__stdcall *start_address)(void *), void *this_ptr, unsigned int initflag);
	static unsigned int __stdcall _ThreadProc(LPVOID lpParameter);
#else
	// C^CgȂꍇ
	static HANDLE Create(LPTHREAD_START_ROUTINE  lpStartAddress, LPVOID  lpThis, DWORD dwCreationFlags);
	static DWORD WINAPI _ThreadProc(LPVOID lpParameter);
#endif
};

// Xbh[JXg[W ev[gNX
template<typename _Ty>
class tls
{
public:
	// RXgN^/fXgN^
	// iCX^X͐ÓÏɊmۂ邽߁AvO̊Jn/I1xĂ΂j
	tls(void) : m_dwIndex(TLS_OUT_OF_INDEXES)
	{
		m_dwIndex = ::TlsAlloc();
	}
	~tls(void)
	{
		::TlsFree(m_dwIndex);
		m_dwIndex = TLS_OUT_OF_INDEXES;
	}

	// Qb^[/Zb^[
	// i_Ty^ł͂ȂA_Ty *^ƂĎ󂯓nsj
	_Ty *GetValuePointer(void)
	{
		LPVOID lpTlsValue = ::TlsGetValue(m_dwIndex);
		return reinterpret_cast<_Ty *>(lpTlsValue);
	}
	void SetValuePointer(_Ty *pValue = NULL)
	{
		::TlsSetValue(m_dwIndex, pValue);
	}

private:
	DWORD m_dwIndex;                        // TLSCfbNX
};

_WGC_END

#endif // __THREAD__
