// Registry.cpp cCve[Vt@C
#include "Registry.h"
#include <tchar.h>


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// RXgNV

// RXgN^ihKeyRootǗj
Registry::Registry(HKEY hKeyRoot /* = HKEY_CURRENT_USER */) : m_bSubKey(FALSE)
{
	m_hKeyRoot = hKeyRoot;
}

// RXgN^2ihKeyRoot̃TuL[Ǘj
Registry::Registry(HKEY hKeyRoot, LPCTSTR lpszSubName, BOOL bCreate /* = FALSE */, REGSAM samDesired /* = KEY_ALL_ACCESS */) : m_bSubKey(TRUE)
{
	m_hKeyRoot = hKeyRoot;
	if(bCreate)
	{
		m_hKeyRoot = CreateSubKey(lpszSubName, REG_OPTION_NON_VOLATILE);
	}
	else
	{
		m_hKeyRoot = OpenSubKey(lpszSubName, samDesired);
	}
}

// fXgN^
Registry::~Registry(void)
{
	if(m_bSubKey && m_hKeyRoot != NULL)
	{
		::RegCloseKey(m_hKeyRoot);
	}
}


////////////////////////////////////////////////////////////////////////////////
// 

Registry::operator HKEY(void)
{
	return m_hKeyRoot;
}


////////////////////////////////////////////////////////////////////////////////
// TuL[֘A

// TuL[쐬
HKEY Registry::CreateSubKey(LPCTSTR lpszSubName, const DWORD dwOptions /* = REG_OPTION_NON_VOLATILE */, const REGSAM samDesired /* = KEY_ALL_ACCESS */)
{
	HKEY hKeyResult;
	DWORD dwDisposition;

	const LONG lResult = ::RegCreateKeyEx(
		m_hKeyRoot,
		lpszSubName,
		NULL, NULL,
		dwOptions,
		samDesired,
		NULL,
		&hKeyResult,
		&dwDisposition);
	if(lResult != ERROR_SUCCESS)
	{
		throw lResult;
	}
	return hKeyResult;
}

// TuL[I[v
HKEY Registry::OpenSubKey(LPCTSTR lpszSubName, const REGSAM samDesired /* = KEY_ALL_ACCESS */)
{
	HKEY hKey;

	const LONG lResult = ::RegOpenKeyEx(m_hKeyRoot, lpszSubName, 0, samDesired, &hKey);
	if(lResult != ERROR_SUCCESS)
	{
		throw lResult;
	}
	return hKey;
}

// TuL[폜
void Registry::DeleteSubKey(LPCTSTR lpszSubName)
{
	// TuL[J
	wgc::Registry regSubKey = OpenSubKey(lpszSubName, KEY_ALL_ACCESS);

	// TuL[̃TuL[
	TCHAR szName[128];
	while(regSubKey.EnumerateSubKey(0, szName, countof(szName)) != ERROR_NO_MORE_ITEMS)
	{
		// L[폜
		regSubKey.DeleteSubKey(szName);
	}

	// ŌɃTuL[폜
	DeleteKey(lpszSubName);
}

// TuL[
LONG Registry::EnumerateSubKey(DWORD dwIndex, LPTSTR lpName, DWORD cbName)
{
	return ::RegEnumKey(m_hKeyRoot, dwIndex, lpName, cbName);
}

void Registry::DeleteKey(LPCTSTR lpszKeyName)
{
	const LONG lResult = ::RegDeleteKey(m_hKeyRoot, lpszKeyName);
	if(lResult != ERROR_SUCCESS)
	{
		throw lResult;
	}
}


////////////////////////////////////////
// 

// Cӂ̃f[^
void Registry::SetValue(LPCTSTR lpszValueName, DWORD dwReserved, DWORD dwType, CONST BYTE *lpData, const DWORD cbData)
{
	const LONG lResult = ::RegSetValueEx(m_hKeyRoot, lpszValueName, dwReserved, dwType, lpData, cbData);
	if(lResult != ERROR_SUCCESS)
	{
		throw lResult;
	}
}

// oCil
void Registry::SetValue(LPCTSTR lpszValueName, CONST BYTE *lpData, const DWORD cbData)
{
	SetValue(lpszValueName, 0, REG_BINARY, lpData, cbData);
}

// 32bitl
void Registry::SetValue(LPCTSTR lpszValueName, const DWORD dwData)
{
	SetValue(lpszValueName, 0, REG_DWORD, reinterpret_cast<CONST BYTE *>(&dwData), sizeof(dwData));
}

// 
void Registry::SetValue(LPCTSTR lpszValueName, const tstring_t &tstr)
{
	SetValue(
		lpszValueName, 0,
		REG_SZ,
		reinterpret_cast<CONST BYTE *>(tstr.c_str()),
		static_cast     <DWORD       >(tstr.length() + 1));
}


////////////////////////////////////////
// ǂݍ

// Cӂ̃f[^ǂݍ
LONG Registry::GetValue(LPCTSTR lpszValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
	const LONG lResult = ::RegQueryValueEx(m_hKeyRoot, lpszValueName, lpReserved, lpType, lpData, lpcbData);
	return lResult;
}

// oCilǂݍ
LONG Registry::GetValue(LPCTSTR lpszValueName, LPBYTE lpData, DWORD &rcbData)
{
	return GetValue(lpszValueName, NULL, NULL, lpData, &rcbData);
}

// 32bitlǂݍ
LONG Registry::GetValue(LPCTSTR lpszValueName, DWORD &rdwData)
{
	DWORD cbData;
	return GetValue(lpszValueName, NULL, NULL, reinterpret_cast<LPBYTE>(&rdwData), &cbData);
}

// ǂݍ
LONG Registry::GetValue(LPCTSTR lpszValueName, tstring_t &tstr)
{
	// ̃TCY擾
	DWORD dwLength = 0;
	const LONG lResult = GetValue(
		lpszValueName,
		NULL, NULL,
		NULL, &dwLength);

	if(lResult != ERROR_SUCCESS)
	{
		return lResult;
	}

	// 擾
	LPTSTR lpString = new TCHAR[dwLength];
	const LONG lResult2 = GetValue(
		lpszValueName,
		NULL, NULL,
		reinterpret_cast<LPBYTE>(lpString),
		&dwLength);

	if(dwLength > 1)
	{
		tstr.assign(lpString, dwLength - 1);
	}
	delete []lpString;

	return lResult2;
}

_WGC_END                                // }
