// ReBarCtrl.h co[̃TuNX
#ifndef __WGC_REBAR__
#define __WGC_REBAR__

#include "Control.h"


_WGC_BEGIN                              // namespace wgc {

class ReBarCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit ReBarCtrl(void);
	virtual ~ReBarCtrl(void);

	BOOL Create(
		Window *pParent,
		const DWORD dwStyle      = WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_BORDER,
		const DWORD dwCtlStyle   = CCS_NODIVIDER,
		const DWORD dwReBarStyle = RBS_BANDBORDERS,
		const DWORD dwExStyle    = WS_EX_TOOLWINDOW,
		const UINT  nID          = IDW_STD_REBAR);

	BOOL AddBar(
		Window *pWindow,
		const DWORD dwStyle = RBBS_GRIPPERALWAYS | RBBS_CHILDEDGE,
		LPCTSTR lpszText    = NULL,
		HBITMAP hBitmap     = NULL);


	// Agr[g
	UINT GetBandCount(void) const;
	BOOL GetBarInfo(REBARINFO &rbi) const;
	BOOL GetBandInfo(const UINT uBand, REBARBANDINFO &rbbi) const;

	// Iy[V
	BOOL SetBarInfo(const REBARINFO &rbi);
	BOOL SetBandInfo(const UINT uBand, const REBARBANDINFO &rbbi);
	BOOL InsertBand(const UINT uBand, const REBARBANDINFO &rbbi);
	BOOL DeleteBand(const UINT uBand);

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(ReBarCtrl)
};

_WGC_END                                // }

#endif // __WGC_REBAR__
