// GdiObject.cpp cCve[Vt@C
#include "GdiObject.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// GDIIuWFNg

GdiObject::GdiObject(HGDIOBJ hObject)
	: m_hObject(NULL), m_bOwner(FALSE)
{
	m_hObject = hObject;
	if(m_hObject == NULL)
	{
		wgfThrowLastError();
	}
}

GdiObject::~GdiObject(void)
{
	if(m_bOwner)
	{
		Delete();
	}
}

// Rs[RXgN^
GdiObject::GdiObject(GdiObject &rObject)
{
	*this = rObject;
	rObject.m_bOwner = FALSE;
}

// Zq
GdiObject &GdiObject::operator =(GdiObject &rObject)
{
	// IuWFNg̏Lړ
	m_hObject = rObject.m_hObject; rObject.m_hObject = NULL;
	m_bOwner  = rObject.m_bOwner;  rObject.m_bOwner  = FALSE;

	return *this;
}


BOOL GdiObject::Delete(void)
{
	HGDIOBJ hObject = m_hObject;
	m_hObject = NULL;

	return ::DeleteObject(hObject);
}


////////////////////////////////////////////////////////////////////////////////
// hGDIIuWFNg

// y
GdiPen::GdiPen(HPEN hPen)
	: GdiObject(hPen)
{
}

GdiPen::GdiPen(const int fnPenStyle, const int nWidth, const COLORREF crColor)
	: GdiObject(::CreatePen(fnPenStyle, nWidth, crColor))
{
	m_bOwner = TRUE;
	if(m_hObject == NULL)
	{
		wgfThrowLastError();
	}
}

GdiPen::~GdiPen(void)
{
}

// tHg
GdiFont::GdiFont(HFONT hFont)
	: GdiObject(hFont)
{
}

GdiFont::GdiFont(
	const int nPointSize, LPCTSTR lpszFaceName,
	const BOOL bBold      /* = FALSE */, const BOOL bItalic    /* = FALSE */,
	const BOOL bUnderline /* = FALSE */, const BOOL bStrikeOut /* = FALSE */)
	: GdiObject(CreatePointFont(nPointSize, lpszFaceName, bBold, bItalic, bUnderline, bStrikeOut))
{
	m_bOwner = TRUE;
	if(m_hObject == NULL)
	{
		wgfThrowLastError();
	}
}

GdiFont::~GdiFont(void)
{
}

HFONT GdiFont::CreatePointFont(
	const DOUBLE fPointSize, LPCTSTR lpszFaceName,
	const BOOL bBold      /* = FALSE */, const BOOL bItalic    /* = FALSE */,
	const BOOL bUnderline /* = FALSE */, const BOOL bStrikeOut /* = FALSE */)
{
	LOGFONT lf;
	lf.lfEscapement     = 0;
	lf.lfOrientation    = 0;
	lf.lfWeight         = bBold ? FW_BOLD : FW_DONTCARE;
	lf.lfItalic         = static_cast<BYTE>(bItalic   );
	lf.lfUnderline      = static_cast<BYTE>(bUnderline);
	lf.lfStrikeOut      = static_cast<BYTE>(bStrikeOut);
	lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
	lf.lfQuality        = DEFAULT_QUALITY;
	lf.lfPitchAndFamily = VARIABLE_PITCH | FF_DONTCARE;
	lf.lfCharSet        = DEFAULT_CHARSET;

	::lstrcpyn(lf.lfFaceName, lpszFaceName, countof(lf.lfFaceName));

	// {block}
	// ƍvZ
	{
		HDC hDC = ::GetDC(NULL);
		lf.lfWidth  = 0;
		lf.lfHeight = -static_cast<LONG>(fPointSize * ::GetDeviceCaps(hDC, LOGPIXELSY) / 72 + 0.5);
		::ReleaseDC(NULL, hDC);
	}

	return ::CreateFontIndirect(&lf);
}

_WGC_END                                // }
