// Dialog.cpp cCve[Vt@C
#include "Dialog.h"
#include "wgfunc.h"                     // wgc::wgfThrowLastError()
#include <windowsx.h>                   // GET_WM_COMMAND_ID()
#include <assert.h>                     // assert()
#include <limits.h>                     // INT_MAX


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
Dialog::Dialog(HINSTANCE hResource, LPCTSTR lpszTemplateName, HWND hWndParent /* = NULL */)
{
	m_hResource        = hResource;
	m_lpszTemplateName = lpszTemplateName;
	m_hWndParent       = hWndParent;
}

// fXgN^
Dialog::~Dialog(void)
{
}


////////////////////////////////////////////////////////////////////////////////
// c[`bv֐

// c[`bv̏
void Dialog::InitToolTips(void)
{
	m_ctrlToolTip.Create(this, WS_POPUP | TTS_ALWAYSTIP, m_hResource);
	m_ctrlToolTip.SetMaxTipWidth(INT_MAX);
}

// c[`bvݒ
void Dialog::SetToolTips(const UINT arID[], const UINT nIDCount)
{
	// IDƂɃc[`bvݒ
	for(UINT i = 0; i < nIDCount; i++)
	{
		HWND hWnd = GetDlgItem(arID[i]);
		if(::IsWindow(hWnd))
		{
			// c[`bvǉ
			m_ctrlToolTip.AddTool(hWnd, m_hResource, arID[i]);
		}
	}
}

void Dialog::SetToolTip(const UINT nID)
{
	SetToolTips(&nID, 1);
}


////////////////////////////////////////////////////////////////////////////////
// \

// [__CAO\
INT_PTR Dialog::DoModal(const LPARAM dwInitParam /* = 0 */)
{
	_SetHookTarget(this);
	const INT_PTR nResult = ::DialogBoxParam(
		m_hResource,
		m_lpszTemplateName,
		m_hWndParent,
		reinterpret_cast<DLGPROC>(_WindowProcBase),
		dwInitParam);

	if(nResult == -1)
	{
		_SetHookTarget(NULL);
	}
	return nResult;
}

// _CAO쐬
BOOL Dialog::DoModeless(const LPARAM dwInitParam /* = 0 */)
{
	_SetHookTarget(this);
	HWND hWnd = ::CreateDialogParam(
		m_hResource,
		m_lpszTemplateName,
		m_hWndParent,
		reinterpret_cast<DLGPROC>(_WindowProcBase),
		dwInitParam);

	if(hWnd == NULL)
	{
		_SetHookTarget(NULL);
		return FALSE;
	}
	assert(hWnd == m_hWnd);
	return TRUE;
}

// _CAOi[hX_CAOj
void Dialog::EndModeless(void)
{
	DestroyWindow();
}


////////////////////////////////////////////////////////////////////////////////
// bZ[W֐

// _CAOACeփbZ[W𑗂
LRESULT Dialog::SendDlgItemMessage(const int nIDDlgItem, const UINT uMsg, const WPARAM wParam /* = 0 */, const LPARAM lParam /* = 0*/)
{
	return ::SendDlgItemMessage(m_hWnd, nIDDlgItem, uMsg, wParam, lParam);
}

// [hX_CAOpbZ[W̔
BOOL Dialog::IsDialogMessage(LPMSG lpMsg)
{
	return ::IsDialogMessage(m_hWnd, lpMsg);
}


////////////////////////////////////////////////////////////////////////////////
// `FbN{^֐

UINT Dialog::IsDlgButtonChecked(const int nIDButton) const
{
	return ::IsDlgButtonChecked(m_hWnd, nIDButton);
}

BOOL Dialog::CheckDlgButton(const int nIDButton, const UINT uCheck)
{
	return ::CheckDlgButton(m_hWnd, nIDButton, uCheck);
}

BOOL Dialog::CheckRadioButton(const int nIDFirstButton, const int nIDLastButton, const int nIDCheckButton)
{
	return ::CheckRadioButton(m_hWnd, nIDFirstButton, nIDLastButton, nIDCheckButton);
}

int Dialog::GetCheckedRadioButton(const int nIDFirstButton, const int nIDLastButton)
{
	for(int id = nIDFirstButton; id <= nIDLastButton; id++)
	{
		if(IsDlgButtonChecked(id) == BST_CHECKED)
		{
			return id;
		}
	}
	return -1;
}


////////////////////////////////////////////////////////////////////////////////
// bp֐

UINT Dialog::GetDlgItemInt(const int nIDDlgItem, BOOL *lpTranslated, const BOOL bSigned /* = TRUE */)
{
	return ::GetDlgItemInt(m_hWnd, nIDDlgItem, lpTranslated, bSigned);
}

void Dialog::SetDlgItemInt(const int nIDDlgItem, const UINT nValue, const BOOL bSigned /* = TRUE */)
{
	const BOOL bResult = ::SetDlgItemInt(m_hWnd, nIDDlgItem, nValue, bSigned);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

UINT Dialog::GetDlgItemText(const int nIDDlgItem, tstring_t &tstr)
{
	TCHAR buffer[256];
	const UINT result = ::GetDlgItemText(m_hWnd, nIDDlgItem, buffer, countof(buffer));

	tstr = buffer;
	return result;
}

void Dialog::SetDlgItemText(const int nIDDlgItem, const tstring_t &tstr)
{
	const BOOL bResult = ::SetDlgItemText(m_hWnd, nIDDlgItem, tstr.c_str());
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

HWND Dialog::SetDlgItemFocus(const int nIDDlgItem)
{
	HWND hWnd = GetDlgItem(nIDDlgItem);
	if(hWnd == NULL)
	{
		return NULL;
	}
	return ::SetFocus(hWnd);
}

void Dialog::EndDialog(const int nResult)
{
	const BOOL bResult = ::EndDialog(m_hWnd, nResult);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// _CAOvV[W

LRESULT CALLBACK Dialog::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		return OnInitDialog(
			reinterpret_cast<HWND>(wParam),              // hWndFocus
			lParam);                                     // dwInitParam
	}
	return Window::WindowProc(uMsg, wParam, lParam);
}

// _CAOvV[W̃ftHg
LRESULT Dialog::_Default(void)
{
	return 0;
}


////////////////////////////////////////////////////////////////////////////////
// _CAObZ[Wnh

// _CAO
BOOL Dialog::OnInitDialog(HWND /* hWndFocus */, const LPARAM /* dwInitParam */)
{
	InitToolTips();
	AssociateDialogControls();
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

// R}h
BOOL Dialog::OnCommand(const WORD /* wNotifyCode */, const WORD wID, HWND /* hWndCtrl */)
{
	switch(wID)
	{
	case IDOK:
		OnOK();
		return FALSE;

	case IDCANCEL:
		OnCancel();
		return FALSE;
	}
	return TRUE;
}

// OK
void Dialog::OnOK(void)
{
	UpdateData(TRUE);
	EndDialog(IDOK);
}

// LZ
void Dialog::OnCancel(void)
{
	EndDialog(IDCANCEL);
}

_WGC_END                                // }
