// edit_manager.h cGfBbgR|[lg̃obt@암
// jł́uXgOvusȂv̈ӖŁA
// @@ueLXgvusiȂjv̈ӖŎgĂB
#ifndef __SGC_EDIT_MANAGER__
#define __SGC_EDIT_MANAGER__

#include "sgc.h"
#include "edit_line.h"                  // sgc::edit_line
#include "undo_buffer.h"                // sgc::undo_buffer<>
#include <list>                         // std::list<>


_SGC_BEGIN                              // namespace sgc {

// ȃobt@암
// obt@ɍs̃IuWFNgƂ̘AgɊւẮA
// ʂōsׂB
class edit_manager
{
private:
	////////////////////////////////////////////////////////////////
	// J̌^`
	typedef std::list<edit_line> linelist_t;
	typedef linelist_t::iterator iterator_t;

	// AhD
	typedef struct _undo_info
	{
		bool       move_cursor;                 // }ɃJ[\ړ邩H
		position_t position;                    // J[\ʒu
		linelist_t text_append;                 // ǉꂽeLXg
		linelist_t text_delete;                 // 폜ꂽeLXg
	} undo_info;

public:
	typedef linelist_t::const_iterator const_iterator_t;
	typedef linelist_t::size_type      linenumber_t;
	typedef edit_line::size_t          size_t;

	typedef struct _modify_info
	{
		linenumber_t modified_line;
		bool         is_modified_linecount;
	} modify_info;

	////////////////////////////////////////////////////////////////
	// RXgNV
	edit_manager (void);
	~edit_manager(void);

	////////////////////////////////////////////////////////////////
	// 
	size_t get_line_count(void) const;
	bool   is_begin(void) const;
	bool   is_end  (void) const;

	////////////////////////////////////////////////////////////////
	// W
	position_t       get_xy(void) const;
	const_iterator_t set_xy(const position_t &position);
	intptr_t get_x(void) const;
	intptr_t get_y(void) const;
	intptr_t set_x(const intptr_t x);
	intptr_t set_y(const intptr_t y);

	////////////////////////////////////////////////////////////////
	// Ce[^
	const_iterator_t get_iterator      (const linenumber_t y) const;
	const_iterator_t get_iterator_begin(void) const;
	const_iterator_t get_iterator_end  (void) const;
	const_iterator_t get_iterator_now  (void) const;

	////////////////////////////////////////////////////////////////
	// ̐ݒ/擾
	void set_readonly(const bool readonly = true);
	bool is_readonly(void) const;
	void set_overwrite(const bool overwrite = true);
	bool is_overwrite (void) const;
	void set_modify(const bool modify = true);
	bool is_modified(void) const;

	////////////////////////////////////////////////////////////////
	// ҏW
	bool     undo(modify_info &mi);
	bool     redo(modify_info &mi);
	bool     can_undo(void) const;
	bool     can_redo(void) const;
	intptr_t set_undo_limit (const intptr_t limit = -1);
	void     empty_undo_buffer(void);
	bool     set_text       (const wchar_t *text, const size_t size);
	bool     insert_text    (const wchar_t *text, const size_t size, modify_info &mi);
	bool     insert_linefeed(modify_info &mi);
	bool     send_string    (const wchar_t *wstr, const size_t length, modify_info &mi);
	bool     delete_char    (const bool left, modify_info &mi);

	////////////////////////////////////////////////////////////////
	// I
	void select_clear (void);
	void select_begin (void);
	void select_end   (void);
	void select_update(void);
	void select_delete(modify_info &mi);
	void select_get_string(wstring_t &wstr) const;
	bool is_selected(void) const;

protected:
	// X^C
	typedef struct _style_t
	{
		unsigned readonly  : 1;                 // ݋֎~tO
		unsigned overwrite : 1;                 // ㏑tO
	} style_t;
	style_t m_style;

	// _
	linelist_t m_list;                      // eLXg̃Xgf[^

	// ҏWʒȕ
	iterator_t m_iterator_now;              // Ce[^
	position_t m_position;                  // ݂̍si0 originj

	// I
	typedef struct _select_t
	{
		typedef struct _select_pos_t
		{
			iterator_t it;
			position_t xy;
		} select_pos_t;

		bool         selected;                  // IĂ邩H
		select_pos_t begin;
		select_pos_t end;
	} select_t;
	select_t m_select;

	// AhD
	undo_buffer<undo_info> m_undo_buffer;


	// A
	bool _Combine(const bool forward, modify_info &mi);

	// ҏW
	void _Delete(iterator_t &pos, const size_t count = 1, const bool forward = true);
	void _DeleteLineList(const linelist_t &buffer);
	void _Insert(linelist_t &buffer, const bool move_buffer = true, const bool move_cursor = true);

	// XN[
	intptr_t _Scroll        (const intptr_t count, const_iterator_t &pos) const;
	intptr_t _ScrollForward (const size_t   count, const_iterator_t &pos) const;
	intptr_t _ScrollBackward(const size_t   count, const_iterator_t &pos) const;

	linenumber_t _GetPosition(const linenumber_t linenumber, const_iterator_t &pos) const;

	static void _CreateLineList(const wchar_t *text, const size_t size, linelist_t &linelist);
};

_SGC_END                                // }

#endif // __SGC_EDIT_MANAGER__
