// edit_line.cpp cCve[Vt@C
#include "edit_line.h"
#include <assert.h>                     // assert()


_SGC_BEGIN                              // namespace sgc {


////////////////////////////////////////////////////////////////////////////////
// RXgNV

edit_line::edit_line(const charcode_linefeed_t lf /* = CL_DEFAULT */)
	: m_lf(lf)
{
}

edit_line::edit_line(const wchar_t *wstr, const edit_line::size_t size, const charcode_linefeed_t lf /* = CL_DEFAULT */)
	: m_lf(lf)
{
	if(size > 0)
	{
		m_buffer.assign(wstr, size);
	}
}

edit_line::edit_line(const wstring_t &wstr, const charcode_linefeed_t lf /* = CL_DEFAULT */)
	: m_lf(lf)
{
	m_buffer = wstr;
}

edit_line::edit_line(const edit_line &rhs)
	: m_lf(rhs.m_lf)
{
	m_buffer = rhs.m_buffer;
}


////////////////////////////////////////////////////////////////////////////////
// 

edit_line::size_t edit_line::length(void) const
{
	return m_buffer.length();
}

const wchar_t *edit_line::c_str(void) const
{
	return m_buffer.c_str();
}

charcode_linefeed_t edit_line::lf_type(void) const
{
	return m_lf;
}

wstring_t edit_line::substr(const pos_t offset, const size_t count /* = -1 */) const
{
	return m_buffer.substr(offset, count);
}


////////////////////////////////////////////////////////////////////////////////
// ҏW

void edit_line::insert(const edit_line::pos_t pos, const wchar_t *wstr, const edit_line::size_t size)
{
	m_buffer.insert(pos, wstr, size);
}

void edit_line::overwrite(const edit_line::pos_t pos, const wchar_t *wstr, const edit_line::size_t size, wstring_t *deleted_ptr /* = NULL */)
{
	if(deleted_ptr != NULL)
	{
		*deleted_ptr = m_buffer.substr(pos, size);
	}
	m_buffer.replace(pos, size, wstr);
}


void edit_line::erase(const edit_line::pos_t pos, const edit_line::size_t size /* = -1 */, wstring_t *deleted_ptr /* = NULL */)
{
	if(deleted_ptr != NULL)
	{
		*deleted_ptr = m_buffer.substr(pos, size);
	}
	m_buffer.erase(pos, size);
}

void edit_line::split(const edit_line::pos_t pos, edit_line &line_front, edit_line &line_rear) const
{
	// {block}
	// O
	{
		std::wstring wstr = m_buffer.substr(0, pos);
		line_front = edit_line(wstr.c_str(), wstr.length());
	}
	// {block}
	// 㔼
	{
		std::wstring wstr = m_buffer.substr(pos);
		line_rear = edit_line(wstr.c_str(), wstr.length(), m_lf);
	}
}


////////////////////////////////////////////////////////////////////////////////
// Zq

edit_line edit_line::operator +(const edit_line &rhs) const
{
	edit_line str = *this;
	str.m_buffer += rhs.m_buffer;
	str.m_lf      = rhs.m_lf;
	return str;
}

edit_line edit_line::operator +(const wstring_t &rhs) const
{
	edit_line str = *this;
	str.m_buffer += rhs;
	return str;
}

edit_line &edit_line::operator +=(const edit_line &rhs)
{
	*this = *this + rhs;
	return *this;
}

edit_line &edit_line::operator +=(const wstring_t &rhs)
{
	m_buffer += rhs;
	return *this;
}

edit_line &edit_line::operator =(const edit_line &rhs)
{
	m_buffer = rhs.m_buffer;
	m_lf     = rhs.m_lf;
	return *this;
}

edit_line &edit_line::operator =(const wstring_t &rhs)
{
	m_buffer = rhs;
	return *this;
}

_SGC_END                                // }
