/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Regular expression utility.
 * (well used functions)
 *
 */
public final class RegexpUtil {

    private RegexpUtil() {
    }

    public static String replaceAll(String input, String regexp,
            String replacement) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replacement);
    }

    public static String replaceAll(String input, String regexp,
            String replacement, int flags) {
        Pattern pattern = Pattern.compile(regexp, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replacement);
    }

    public static String replaceFirst(String input, String regexp,
            String replacement) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceFirst(replacement);
    }

    public static String replaceFirst(String input, String regexp,
            String replacement, int flags) {
        Pattern pattern = Pattern.compile(regexp, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceFirst(replacement);
    }

    public static boolean find(String input, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static boolean find(String input, String regexp, int flags) {
        Pattern pattern = Pattern.compile(regexp, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static boolean findFrom(String input, String regexp, int start) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(input);
        return matcher.find(start);
    }

    public static boolean findFrom(String input, String regexp, int start, int flags) {
        Pattern pattern = Pattern.compile(regexp, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.find(start);
    }

    public static boolean matches(String input, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static boolean matches(String input, String regexp, int flags) {
        Pattern pattern = Pattern.compile(regexp, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

}
