/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.core;

import org.maru.core.Key;

/**
 * This class is a base class of all binding class.
 *
 * @param <T>
 */
public abstract class BinderImpl<T> implements Binder<T> {
    protected final Class<T> type;
    protected final Key<?> key;

    public BinderImpl(Key<?> key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    @Override
    public Key<?> getkey() {
        return key;
    }

    @Override
    public Class<T> getType() {
        return type;
    }

}
