/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.converter;

import org.maru.core.annotation.Identifier;
import org.maru.core.annotation.Value;
import org.maru.dog.util.RegexpUtil;

/**
 * Regular expression converter.
 *
 */
public final class RegexpConverter {

    @ConverterIdentifier(ReplaceAll.class)
    public String replaceAll(@Value String input,
            @Identifier("regexp") String regexp,
            @Identifier("replacement") String replacement,
            @Identifier("flags") int flags) {
        return RegexpUtil.replaceAll(input, regexp, replacement, flags);
    }

    @ConverterIdentifier(ReplaceFirst.class)
    public String replaceFirst(@Value String input,
            @Identifier("regexp") String regexp,
            @Identifier("replacement") String replacement,
            @Identifier("flags") int flags) {
        return RegexpUtil.replaceFirst(input, regexp, replacement, flags);
    }

}
