/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.ArrayList;
import java.util.List;

import org.maru.core.Key;
import org.maru.dog.core.BinderImpl;

final class InstanceBinderImpl<T, K> extends BinderImpl<T> implements InstanceBinder<T, K> {

    private final List<MemberBinder<T, K>> binders = new ArrayList<MemberBinder<T, K>>();

    public InstanceBinderImpl(Key<?> key, Class<T> type) {
        super(key, type);
    }

    @Override
    public InternalCallableBinder<T, K> getCallableBinder(T target, K... inputs) {
        return new InternalCallableBinderImpl<T, K>(this, target, inputs);
    }

    static class InternalCallableBinderImpl<T, K> implements InternalCallableBinder<T, K> {
        final T target;
        final K[] inputs;
        final InstanceBinderImpl<T, K> instanceBinder;

        InternalCallableBinderImpl(InstanceBinderImpl<T, K> instanceBinder, T target, K... inputs) {
            this.target = target;
            this.inputs = inputs;
            this.instanceBinder = instanceBinder;
        }

        @Override
        public T callableBind() {
            return instanceBinder.bind(target, inputs);
        }

    }

    @Override
    public void addMemberBinder(MemberBinder<T, K> memberBinder) {
        this.binders.add(memberBinder);
    }

    @SuppressWarnings("unchecked")
    T bind(T target, K... inputs) {
        for (K input : inputs) {
            Class<K> inputType = (Class<K>) input.getClass();
            for (MemberBinder<T, K> memberBinder : binders) {
                if (memberBinder.getBindingContext().getInputMarkedPoint().getDeclaringClass().equals(inputType)) {
                    memberBinder.bind(target, input);
                }
            }

        }
        return target;
    }


}
