/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.lang.reflect.Member;

import org.maru.dog.core.MarkedPoint;

/**
 * This class indicates the marking point of the input
 * object described by anything.
 *
 */
class InputMarkedPoint<T> extends MarkedPoint<T> {

    private ConverterDef converterDef;


    public InputMarkedPoint() {
        super();
    }

    public InputMarkedPoint(Class<T> declaringClass, String name,
            Member member, ConverterDef converterDef) {
        super(declaringClass, name,  member);
        this.converterDef = converterDef;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        sb.append("InputMarkedPoint [");
        sb.append("declaringClass=" + declaringClass.getName() + ", ");
        sb.append("converterDef=" + converterDef + ", ");
        sb.append("member=" + member + ", ");
        sb.append("name=" + name + "]");
        return sb.toString();
    }

    public ConverterDef getConverterDef() {
        return converterDef;
    }

    public void setConverterDef(ConverterDef converterDef) {
        this.converterDef = converterDef;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((declaringClass == null) ? 0 : declaringClass.hashCode());
        result = prime * result + ((member == null) ? 0 : member.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((converterDef == null) ? 0 : converterDef.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        InputMarkedPoint<?> other = (InputMarkedPoint<?>) obj;
        if (declaringClass == null) {
            if (other.declaringClass != null)
                return false;
        } else if (!declaringClass.equals(other.declaringClass)) {
            return false;
        }

        if (member == null) {
            if (other.member != null)
                return false;
        } else if (!member.equals(other.member)) {
            return false;
        }

        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name)) {
            return false;
        }

        if (converterDef == null) {
            if (other.converterDef != null)
                return false;
        } else if (!converterDef.equals(other.converterDef)) {
            return false;
        }

        return true;
    }

}
