/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.concurrent.ConcurrentMap;
import org.maru.core.Key;
import org.maru.core.MapFactory;

public class ConverterCache {

    /** The cache for cnoverter objects */
    private static final ConcurrentMap<Key<?>, Object> CACHED_CONVERTERS = MapFactory.createConcurrentSoftMap();

    private ConverterCache(){}


    public static Object apply(Key<?> key, Object value) {
        return CACHED_CONVERTERS.putIfAbsent(key, value);
    }

    public static Object get(Key<?> key) {
        return CACHED_CONVERTERS.get(key);
    }

    public static boolean containsKey(Key<?> key) {
        return CACHED_CONVERTERS.containsKey(key);
    }

    public static void clear() {
        CACHED_CONVERTERS.clear();
    }

    public static Object remove(Key<?> key) {
        return CACHED_CONVERTERS.remove(key);
    }

}
