/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.HashMap;
import java.util.Map;

import org.maru.core.Key;
import org.maru.dog.core.MarkedPoint;

/**
 * This class represents class definition for marked binding points.
 *
 */
final class BindingDefinitionImpl<T> implements BindingDefinition<T> {

    private Class<T> type;
    private final Map<Key<?>, MarkedPoint<T>> markedPoints = new HashMap<Key<?>, MarkedPoint<T>>();

    public BindingDefinitionImpl() {}

    public BindingDefinitionImpl(Class<T> type) {
        this.type = type;
    }


    @Override
    public Class<T> getType() {
        return type;
    }

    @Override
    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public MarkedPoint<T> putMarkedPoint(Key<?> key, MarkedPoint<T> markedPoint) {
        if (this.markedPoints.containsKey(key)) {
            throw new IllegalArgumentException("[Duplicate error Key = " + key.toString() + "] This key has already been contained.");
        }
        return this.markedPoints.put(key, markedPoint);
    }

    @Override
    public MarkedPoint<T> getMarkedPoint(Key<?> key) {
        return this.markedPoints.get(key);
    }

    @Override
    public void putAllMarkedPoint(Map<Key<?>, MarkedPoint<T>> markedPoints) {
        markedPoints.putAll(markedPoints);
    }

    @Override
    public boolean containsMarkedPoint(Key<?> key) {
        return markedPoints.containsKey(key);
    }

    @Override
    public Map<Key<?>, MarkedPoint<T>> getMarkedPoints() {
        return markedPoints;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BindingDefinitionImpl [type=" + type);
        sb.append(", markedPoints=" + markedPoints +  "]");
        return sb.toString();
    }

}
