/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.lang.reflect.Member;
import java.lang.reflect.Method;

import org.maru.core.reflection.Methods;

/**
 * This class binds the binding data on the input instance to the target bound
 * point by using the method on the target object.
 */
public class AccessorMethodBinder<T, K> implements MemberBinder<T, K> {

    private final BindingContext<T, K> context;

    private final BindingFactory factory;

    public AccessorMethodBinder(BindingContext<T, K> context) {
        this.context = context;
        this.factory = new BindingFactoryImpl();
    }

    @Override
    public void bind(T target, K input) {
        Object value = factory.get(context, input);
        Member member = context.getTargetMarkedPoint().getMember();

        Methods.invoke((Method) member, target, value);

    }

    @Override
    public BindingContext<T, K> getBindingContext() {
        return this.context;
    }

}
