/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.util;

/**
 * String utility class.
 *
 */
public final class StringUtil {

    private StringUtil() {}

    /**
     * checks target string passed by a parameter is not null and empty.
     *
     * @param target
     *            checked string.
     * @return true if target string is not null and empty, otherwise false.
     */
    public static boolean isNotEmpty(String target) {
        if (target != null && !target.equals("")) {
            return true;
        }
        return false;
    }

    /**
     * checks target string passed by a parameter is null or empty.
     *
     * @param target
     *            checked string
     * @return true if target string is null or empty, otherwise false.
     */
    public static boolean isEmpty(String target) {
        if (target == null || target.equals("")) {
            return true;
        }
        return false;
    }
}
