/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.type;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

/**
 * Wild card class type wrapper.
 *
 */
public class WrappedWildcardType implements WildcardType, RealType,
        Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -7493969869558858067L;
    private WildcardType type;

    public WrappedWildcardType() {
    }

    public WrappedWildcardType(WildcardType type) {
        this.type = type;
    }

    @Override
    public WildcardType getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = (WildcardType) type;
    }

    @Override
    public Type[] getLowerBounds() {
        return this.type.getLowerBounds();
    }

    @Override
    public Type[] getUpperBounds() {
        return this.type.getUpperBounds();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WrappedWildcardType other = (WrappedWildcardType) obj;
        if (type == null) {
            if (other.type != null)
                return false;
        } else if (Arrays.equals(
                GenericClassType.getGenericClassTypes(type.getLowerBounds()),
                GenericClassType.getGenericClassTypes(other.type.getLowerBounds()))
                && Arrays.equals(
                        GenericClassType.getGenericClassTypes(type.getUpperBounds()),
                        GenericClassType.getGenericClassTypes(other.type.getUpperBounds()))) {
            return true;

        }
        return false;
    }

    @Override
    public String toString() {
        return "WrappedWildcardType [type=" + type + "]";
    }


}
