/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.type;

import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

/**
 * {@link TypeVariable} class wrapper.
 *
 */
public class WrappedTypeVariable<D extends GenericDeclaration> implements
        TypeVariable, RealType, Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 92605995526016716L;
    private TypeVariable<D> type;

    public WrappedTypeVariable() {
    }

    public WrappedTypeVariable(TypeVariable<D> type) {
        this.type = type;
    }

    @Override
    public TypeVariable<D> getType() {
        return type;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void setType(Type type) {
        this.type = (TypeVariable<D>) type;
    }

    @Override
    public Type[] getBounds() {
        return this.type.getBounds();
    }

    @Override
    public D getGenericDeclaration() {
        return this.type.getGenericDeclaration();
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WrappedTypeVariable<? extends GenericDeclaration> other = (WrappedTypeVariable<? extends GenericDeclaration>) obj;
        if (type == null) {
            if (other.type != null)
                return false;
        } else {
            if (type.getGenericDeclaration().equals(other.type.getGenericDeclaration())
                    && Arrays.equals(
                            GenericClassType.getGenericClassTypes(type.getBounds()),
                            GenericClassType.getGenericClassTypes(other.type.getBounds()))) {
                return true;
            }
        }
        return false;
    }

    public static Class<?> getClassFromType(
            TypeVariable<? extends GenericDeclaration> type) {
        // Is this correct ?
        return GenericClassType.getClassFromType(type.getBounds()[0]);
    }

    @Override
    public String toString() {
        return "WrappedTypeVariable [type=" + type + "]";
    }

}
