/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.type;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

/**
 * Generic array class type wrapper.
 *
 */
public class WrappedGenericArrayType implements GenericArrayType, RealType,
        Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1108665436635406280L;
    private GenericArrayType type;

    public WrappedGenericArrayType() {
    }

    public WrappedGenericArrayType(GenericArrayType type) {
        this.type = type;
    }

    @Override
    public Type getGenericComponentType() {
        return type.getGenericComponentType();
    }

    @Override
    public GenericArrayType getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = (GenericArrayType) type;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WrappedGenericArrayType other = (WrappedGenericArrayType) obj;
        if (type == null) {
            if (other.type != null)
                return false;
        } else {
            GenericClassType genericComponentType = GenericClassType
                    .getGenericClassType(type.getGenericComponentType());
            GenericClassType otherGenericComponentType = GenericClassType
                    .getGenericClassType(other.type.getGenericComponentType());

            return genericComponentType.equals(otherGenericComponentType);
        }
        return false;
    }

    public static Class<?> getClassFromType(Type type) {
        return Array.newInstance(
                GenericClassType.getClassFromType(((GenericArrayType) type)
                        .getGenericComponentType()), 0).getClass();
    }

    @Override
    public String toString() {
        return "WrappedGenericArrayType [type=" + type + "]";
    }

}
