/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.type;

import java.io.Serializable;
import java.lang.reflect.Type;

/**
 * Class type wrapper.
 *
 */
public class WrappedClass implements RealType, Type, Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -6317171980610240347L;
    private Class<?> clazz;

    public WrappedClass(){
    }

    public WrappedClass(Type type) {
        this.clazz = (Class<?>)type;
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public void setType(Type type) {
        this.clazz = (Class<?>)type;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((clazz == null) ? 0 : clazz.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WrappedClass other = (WrappedClass) obj;
        if (clazz == null) {
            if (other.clazz != null)
                return false;
        } else if (!clazz.equals(other.clazz))
            return false;
        return true;
    }

    public static Class<?> getClassFromType(Type type) {
        return (Class<?>)type;
    }

    @Override
    public String toString() {
        return "WrappedClass [type=" + clazz + "]";
    }

}
